/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Predicate;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DruidDoublePredicate;
import io.druid.query.filter.DruidFloatPredicate;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.segment.filter.DimensionPredicateFilter;
import java.util.regex.Pattern;

public class RegexFilter
extends DimensionPredicateFilter {
    public RegexFilter(String dimension, final Pattern pattern, ExtractionFn extractionFn) {
        super(dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return input -> input != null && pattern.matcher((CharSequence)input).find();
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return input -> pattern.matcher(String.valueOf(input)).find();
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return input -> pattern.matcher(String.valueOf(input)).find();
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return input -> pattern.matcher(String.valueOf(input)).find();
            }

            public String toString() {
                return "RegexFilter{pattern='" + pattern + '\'' + '}';
            }
        }, extractionFn);
    }
}

