/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Predicate;
import io.druid.query.BitmapResultFactory;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.JavaScriptDimFilter;
import io.druid.query.filter.ValueMatcher;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.filter.Filters;
import org.mozilla.javascript.Context;

public class JavaScriptFilter
implements Filter {
    private final String dimension;
    private final JavaScriptDimFilter.JavaScriptPredicateFactory predicateFactory;

    public JavaScriptFilter(String dimension, JavaScriptDimFilter.JavaScriptPredicateFactory predicate) {
        this.dimension = dimension;
        this.predicateFactory = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        Context cx = Context.enter();
        try {
            T t = Filters.matchPredicate(this.dimension, selector, bitmapResultFactory, this.makeStringPredicate(cx));
            return t;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        Context cx = Context.enter();
        try {
            double d = Filters.estimateSelectivity(this.dimension, indexSelector, this.makeStringPredicate(cx));
            return d;
        }
        finally {
            Context.exit();
        }
    }

    private Predicate<String> makeStringPredicate(final Context context) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return JavaScriptFilter.this.predicateFactory.applyInContext(context, input);
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }
}

