/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.java.util.common.guava.FunctionalIterable;
import io.druid.query.BitmapResultFactory;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.Query;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.BooleanFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategyFactory;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.IntIteratorUtils;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.AndFilter;
import io.druid.segment.filter.NotFilter;
import io.druid.segment.filter.OrFilter;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Filters {
    public static final List<ValueType> FILTERABLE_TYPES = ImmutableList.of((Object)((Object)ValueType.STRING), (Object)((Object)ValueType.LONG), (Object)((Object)ValueType.FLOAT), (Object)((Object)ValueType.DOUBLE));
    private static final String CTX_KEY_USE_FILTER_CNF = "useFilterCNF";

    public static List<Filter> toFilters(List<DimFilter> dimFilters) {
        return ImmutableList.copyOf((Iterable)FunctionalIterable.create(dimFilters).transform((Function)new Function<DimFilter, Filter>(){

            public Filter apply(DimFilter input) {
                return input.toFilter();
            }
        }));
    }

    public static Filter toFilter(DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toFilter();
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, String value) {
        ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), DefaultDimensionSpec.of(columnName), columnSelectorFactory);
        return selector.getColumnSelectorStrategy().makeValueMatcher(selector.getSelector(), value);
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, DruidPredicateFactory predicateFactory) {
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(columnName);
        if (capabilities != null && capabilities.getType() == ValueType.LONG) {
            return Filters.getLongPredicateMatcher(columnSelectorFactory.makeColumnValueSelector(columnName), predicateFactory.makeLongPredicate());
        }
        ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), DefaultDimensionSpec.of(columnName), columnSelectorFactory);
        return selector.getColumnSelectorStrategy().makeValueMatcher(selector.getSelector(), predicateFactory);
    }

    public static ImmutableBitmap allFalse(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().makeEmptyImmutableBitmap();
    }

    public static ImmutableBitmap allTrue(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
    }

    static Iterable<ImmutableBitmap> bitmapsFromIndexes(final IntIterable indexes, final BitmapIndex bitmapIndex) {
        return new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                final IntIterator iterator = indexes.iterator();
                return new Iterator<ImmutableBitmap>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return bitmapIndex.getBitmap(iterator.nextInt());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> T matchPredicate(String dimension, BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, Predicate<String> predicate) {
        return bitmapResultFactory.unionDimensionValueBitmaps(Filters.matchPredicateNoUnion(dimension, selector, predicate));
    }

    public static Iterable<ImmutableBitmap> matchPredicateNoUnion(String dimension, BitmapIndexSelector selector, Predicate<String> predicate) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        Indexed<String> dimValues = selector.getDimensionValues(dimension);
        if (dimValues == null || dimValues.size() == 0) {
            return ImmutableList.of((Object)(predicate.apply(null) ? Filters.allTrue(selector) : Filters.allFalse(selector)));
        }
        BitmapIndex bitmapIndex = selector.getBitmapIndex(dimension);
        return Filters.makePredicateQualifyingBitmapIterable(bitmapIndex, predicate, dimValues);
    }

    public static double estimateSelectivity(String dimension, BitmapIndexSelector indexSelector, Predicate<String> predicate) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkNotNull((Object)indexSelector, (Object)"selector");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        Indexed<String> dimValues = indexSelector.getDimensionValues(dimension);
        if (dimValues == null || dimValues.size() == 0) {
            return predicate.apply(null) ? 1.0 : 0.0;
        }
        BitmapIndex bitmapIndex = indexSelector.getBitmapIndex(dimension);
        return Filters.estimateSelectivity(bitmapIndex, IntIteratorUtils.toIntList(Filters.makePredicateQualifyingIndexIterable(bitmapIndex, predicate, dimValues).iterator()), indexSelector.getNumRows());
    }

    public static double estimateSelectivity(BitmapIndex bitmapIndex, IntList bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        for (int i = 0; i < bitmaps.size(); ++i) {
            ImmutableBitmap bitmap = bitmapIndex.getBitmap(bitmaps.getInt(i));
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    public static double estimateSelectivity(Iterator<ImmutableBitmap> bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        while (bitmaps.hasNext()) {
            ImmutableBitmap bitmap = bitmaps.next();
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    private static Iterable<ImmutableBitmap> makePredicateQualifyingBitmapIterable(BitmapIndex bitmapIndex, Predicate<String> predicate, Indexed<String> dimValues) {
        return Filters.bitmapsFromIndexes(Filters.makePredicateQualifyingIndexIterable(bitmapIndex, predicate, dimValues), bitmapIndex);
    }

    private static IntIterable makePredicateQualifyingIndexIterable(final BitmapIndex bitmapIndex, final Predicate<String> predicate, final Indexed<String> dimValues) {
        return new IntIterable(){

            public IntIterator iterator() {
                return new IntIterator(){
                    private final int bitmapIndexCardinality;
                    private int nextIndex;
                    private int found;
                    {
                        this.bitmapIndexCardinality = bitmapIndex.getCardinality();
                        this.nextIndex = 0;
                        this.found = -1;
                        this.found = this.findNextIndex();
                    }

                    private int findNextIndex() {
                        while (this.nextIndex < this.bitmapIndexCardinality && !predicate.apply(dimValues.get(this.nextIndex))) {
                            ++this.nextIndex;
                        }
                        if (this.nextIndex < this.bitmapIndexCardinality) {
                            return this.nextIndex++;
                        }
                        return -1;
                    }

                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    public int nextInt() {
                        int foundIndex = this.found;
                        if (foundIndex == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNextIndex();
                        return foundIndex;
                    }
                };
            }
        };
    }

    static boolean supportsSelectivityEstimation(Filter filter, String dimension, ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        Column column;
        if (filter.supportsBitmapIndex(indexSelector) && (column = columnSelector.getColumn(dimension)) != null) {
            return !column.getCapabilities().hasMultipleValues();
        }
        return false;
    }

    public static ValueMatcher getLongPredicateMatcher(final BaseLongColumnValueSelector longSelector, final DruidLongPredicate predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyLong(longSelector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("longSelector", longSelector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static Filter convertToCNFFromQueryContext(Query query, Filter filter) {
        if (filter == null) {
            return null;
        }
        boolean useCNF = query.getContextBoolean(CTX_KEY_USE_FILTER_CNF, false);
        return useCNF ? Filters.convertToCNF(filter) : filter;
    }

    public static Filter convertToCNF(Filter current) {
        current = Filters.pushDownNot(current);
        current = Filters.flatten(current);
        current = Filters.convertToCNFInternal(current);
        current = Filters.flatten(current);
        return current;
    }

    private static Filter pushDownNot(Filter current) {
        ArrayList children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return Filters.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                ArrayList children2 = Lists.newArrayList();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new OrFilter(children2);
            }
            if (child instanceof OrFilter) {
                ArrayList children3 = Lists.newArrayList();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new AndFilter(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = Lists.newArrayList();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            children = Lists.newArrayList();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new OrFilter(children);
        }
        return current;
    }

    private static Filter convertToCNFInternal(Filter current) {
        if (current instanceof NotFilter) {
            return new NotFilter(Filters.convertToCNFInternal(((NotFilter)current).getBaseFilter()));
        }
        if (current instanceof AndFilter) {
            ArrayList children = Lists.newArrayList();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.convertToCNFInternal(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    for (Filter grandChild : ((OrFilter)child).getFilters()) {
                        nonAndList.add(grandChild);
                    }
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                ArrayList result = Lists.newArrayList();
                Filters.generateAllCombinations(result, andList, nonAndList);
                return new AndFilter(result);
            }
        }
        return current;
    }

    private static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            children.addAll(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = Filters.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    List<Filter> grandKids = ((BooleanFilter)child).getFilters();
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(List<Filter> result, List<Filter> andList, List<Filter> nonAndList) {
        List<Filter> children = ((AndFilter)andList.get(0)).getFilters();
        if (result.isEmpty()) {
            for (Filter child : children) {
                ArrayList a = Lists.newArrayList(nonAndList);
                a.add(child);
                result.add(new OrFilter(a));
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    ArrayList a = Lists.newArrayList(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(new OrFilter(a));
                }
            }
        }
        if (andList.size() > 1) {
            Filters.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
        }
    }
}

