/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.druid.math.expr.Evals;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.Parser;
import io.druid.query.BitmapResultFactory;
import io.druid.query.expression.ExprUtils;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.filter.Filters;
import io.druid.segment.virtual.ExpressionSelectors;
import java.util.Collection;
import java.util.Set;

public class ExpressionFilter
implements Filter {
    private final Expr expr;
    private final Set<String> requiredBindings;

    public ExpressionFilter(Expr expr) {
        this.expr = expr;
        this.requiredBindings = ImmutableSet.copyOf((Collection)Parser.findRequiredBindings((Expr)expr));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ColumnValueSelector<ExprEval> selector = ExpressionSelectors.makeExprEvalSelector(factory, this.expr);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Evals.asBoolean((long)selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        if (this.requiredBindings.isEmpty()) {
            return true;
        }
        if (this.requiredBindings.size() == 1) {
            String column = (String)Iterables.getOnlyElement(this.requiredBindings);
            return selector.getBitmapIndex(column) != null && !selector.hasMultipleValues(column);
        }
        return false;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.requiredBindings.isEmpty()) {
            if (this.expr.eval(ExprUtils.nilBindings()).asBoolean()) {
                return bitmapResultFactory.wrapAllTrue(Filters.allTrue(selector));
            }
            return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
        }
        String column = (String)Iterables.getOnlyElement(this.requiredBindings);
        return Filters.matchPredicate(column, selector, bitmapResultFactory, (Predicate<String>)((Predicate)value -> this.expr.eval(identifierName -> {
            assert (column.equals(identifierName));
            return value;
        }).asBoolean()));
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }
}

