/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.java.util.common.Pair;
import io.druid.query.BitmapResultFactory;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DruidDoublePredicate;
import io.druid.query.filter.DruidFloatPredicate;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.ordering.StringComparators;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.IntListUtils;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.filter.Filters;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;

public class BoundFilter
implements Filter {
    private final BoundDimFilter boundDimFilter;
    private final Comparator<String> comparator;
    private final ExtractionFn extractionFn;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

    public BoundFilter(BoundDimFilter boundDimFilter) {
        this.boundDimFilter = boundDimFilter;
        this.comparator = boundDimFilter.getOrdering();
        this.extractionFn = boundDimFilter.getExtractionFn();
        this.longPredicateSupplier = boundDimFilter.getLongPredicateSupplier();
        this.floatPredicateSupplier = boundDimFilter.getFloatPredicateSupplier();
        this.doublePredicateSupplier = boundDimFilter.getDoublePredicateSupplier();
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.supportShortCircuit()) {
            BitmapIndex bitmapIndex = selector.getBitmapIndex(this.boundDimFilter.getDimension());
            if (bitmapIndex == null || bitmapIndex.getCardinality() == 0) {
                if (this.doesMatch(null)) {
                    return bitmapResultFactory.wrapAllTrue(Filters.allTrue(selector));
                }
                return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
            }
            return bitmapResultFactory.unionDimensionValueBitmaps(BoundFilter.getBitmapIterator(this.boundDimFilter, bitmapIndex));
        }
        return Filters.matchPredicate(this.boundDimFilter.getDimension(), selector, bitmapResultFactory, this.getPredicateFactory().makeStringPredicate());
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        if (this.supportShortCircuit()) {
            BitmapIndex bitmapIndex = indexSelector.getBitmapIndex(this.boundDimFilter.getDimension());
            if (bitmapIndex == null || bitmapIndex.getCardinality() == 0) {
                return this.doesMatch(null) ? 1.0 : 0.0;
            }
            return Filters.estimateSelectivity(bitmapIndex, BoundFilter.getBitmapIndexList(this.boundDimFilter, bitmapIndex), indexSelector.getNumRows());
        }
        return Filters.estimateSelectivity(this.boundDimFilter.getDimension(), indexSelector, this.getPredicateFactory().makeStringPredicate());
    }

    private boolean supportShortCircuit() {
        return this.boundDimFilter.getOrdering().equals(StringComparators.LEXICOGRAPHIC) && this.extractionFn == null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.boundDimFilter.getDimension(), this.getPredicateFactory());
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.boundDimFilter.getDimension()) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.boundDimFilter.getDimension(), columnSelector, indexSelector);
    }

    private static Pair<Integer, Integer> getStartEndIndexes(BoundDimFilter boundDimFilter, BitmapIndex bitmapIndex) {
        int found;
        int startIndex = !boundDimFilter.hasLowerBound() ? 0 : ((found = bitmapIndex.getIndex(boundDimFilter.getLower())) >= 0 ? (boundDimFilter.isLowerStrict() ? found + 1 : found) : -(found + 1));
        int endIndex = !boundDimFilter.hasUpperBound() ? bitmapIndex.getCardinality() : ((found = bitmapIndex.getIndex(boundDimFilter.getUpper())) >= 0 ? (boundDimFilter.isUpperStrict() ? found : found + 1) : -(found + 1));
        endIndex = startIndex > endIndex ? startIndex : endIndex;
        return new Pair((Object)startIndex, (Object)endIndex);
    }

    private static Iterable<ImmutableBitmap> getBitmapIterator(BoundDimFilter boundDimFilter, BitmapIndex bitmapIndex) {
        return Filters.bitmapsFromIndexes((IntIterable)BoundFilter.getBitmapIndexList(boundDimFilter, bitmapIndex), bitmapIndex);
    }

    private static IntList getBitmapIndexList(BoundDimFilter boundDimFilter, BitmapIndex bitmapIndex) {
        Pair<Integer, Integer> indexes = BoundFilter.getStartEndIndexes(boundDimFilter, bitmapIndex);
        int startIndex = (Integer)indexes.lhs;
        int endIndex = (Integer)indexes.rhs;
        return IntListUtils.fromTo(startIndex, endIndex);
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                if (BoundFilter.this.extractionFn != null) {
                    return input -> BoundFilter.this.doesMatch(BoundFilter.this.extractionFn.apply((String)input));
                }
                return input -> BoundFilter.this.doesMatch(input);
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                if (BoundFilter.this.extractionFn != null) {
                    return input -> BoundFilter.this.doesMatch(BoundFilter.this.extractionFn.apply(input));
                }
                if (BoundFilter.this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                    return (DruidLongPredicate)BoundFilter.this.longPredicateSupplier.get();
                }
                return input -> BoundFilter.this.doesMatch(String.valueOf(input));
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                if (BoundFilter.this.extractionFn != null) {
                    return input -> BoundFilter.this.doesMatch(BoundFilter.this.extractionFn.apply(Float.valueOf(input)));
                }
                if (BoundFilter.this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                    return (DruidFloatPredicate)BoundFilter.this.floatPredicateSupplier.get();
                }
                return input -> BoundFilter.this.doesMatch(String.valueOf(input));
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                if (BoundFilter.this.extractionFn != null) {
                    return input -> BoundFilter.this.doesMatch(BoundFilter.this.extractionFn.apply(input));
                }
                if (BoundFilter.this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                    return (DruidDoublePredicate)BoundFilter.this.doublePredicateSupplier.get();
                }
                return input -> BoundFilter.this.doesMatch(String.valueOf(input));
            }
        };
    }

    private boolean doesMatch(String input) {
        if (input == null) {
            return (!this.boundDimFilter.hasLowerBound() || this.boundDimFilter.getLower().isEmpty() && !this.boundDimFilter.isLowerStrict()) && (!this.boundDimFilter.hasUpperBound() || !this.boundDimFilter.getUpper().isEmpty() || !this.boundDimFilter.isUpperStrict());
        }
        int lowerComparing = 1;
        int upperComparing = 1;
        if (this.boundDimFilter.hasLowerBound()) {
            lowerComparing = this.comparator.compare(input, this.boundDimFilter.getLower());
        }
        if (this.boundDimFilter.hasUpperBound()) {
            upperComparing = this.comparator.compare(this.boundDimFilter.getUpper(), input);
        }
        if (this.boundDimFilter.isLowerStrict() && this.boundDimFilter.isUpperStrict()) {
            return lowerComparing > 0 && upperComparing > 0;
        }
        if (this.boundDimFilter.isLowerStrict()) {
            return lowerComparing > 0 && upperComparing >= 0;
        }
        if (this.boundDimFilter.isUpperStrict()) {
            return lowerComparing >= 0 && upperComparing > 0;
        }
        return lowerComparing >= 0 && upperComparing >= 0;
    }
}

