/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.java.util.common.StringUtils;
import io.druid.query.BitmapResultFactory;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.BooleanFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.RowOffsetMatcherFactory;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.filter.Filters;
import java.util.ArrayList;
import java.util.List;

public class AndFilter
implements BooleanFilter {
    private static final Joiner AND_JOINER = Joiner.on((String)" && ");
    static final ValueMatcher[] EMPTY_VALUE_MATCHER_ARRAY = new ValueMatcher[0];
    private final List<Filter> filters;

    public AndFilter(List<Filter> filters) {
        Preconditions.checkArgument((filters.size() > 0 ? 1 : 0) != 0, (Object)"Can't construct empty AndFilter");
        this.filters = filters;
    }

    public static <T> ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, List<Filter> filters) {
        return bitmapResultFactory.toImmutableBitmap(AndFilter.getBitmapResult(selector, bitmapResultFactory, filters));
    }

    private static <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, List<Filter> filters) {
        if (filters.size() == 1) {
            return filters.get(0).getBitmapResult(selector, bitmapResultFactory);
        }
        ArrayList bitmapResults = Lists.newArrayListWithCapacity((int)filters.size());
        for (Filter filter : filters) {
            Preconditions.checkArgument((boolean)filter.supportsBitmapIndex(selector), (String)"Filter[%s] does not support bitmap index", (Object[])new Object[]{filter});
            T bitmapResult = filter.getBitmapResult(selector, bitmapResultFactory);
            if (bitmapResultFactory.isEmpty(bitmapResult)) {
                return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
            }
            bitmapResults.add(bitmapResult);
        }
        return bitmapResultFactory.intersection(bitmapResults);
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return AndFilter.getBitmapResult(selector, bitmapResultFactory, this.filters);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return this.makeMatcher(matchers);
    }

    @Override
    public ValueMatcher makeMatcher(BitmapIndexSelector selector, ColumnSelectorFactory columnSelectorFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) {
                bitmaps.add(filter.getBitmapIndex(selector));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(columnSelectorFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().intersection(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return this.makeMatcher(matchers.toArray(EMPTY_VALUE_MATCHER_ARRAY));
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        for (Filter filter : this.filters) {
            if (filter.supportsSelectivityEstimation(columnSelector, indexSelector)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        double selectivity = 1.0;
        for (Filter filter : this.filters) {
            selectivity *= filter.estimateSelectivity(indexSelector);
        }
        return selectivity;
    }

    public String toString() {
        return StringUtils.format((String)"(%s)", (Object[])new Object[]{AND_JOINER.join(this.filters)});
    }

    private ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (matcher.matches()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }
}

