/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.java.util.common.IAE;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VSizeLongSerde {
    public static final int[] SUPPORTED_SIZES = new int[]{1, 2, 4, 8, 12, 16, 20, 24, 32, 40, 48, 56, 64};
    public static final byte[] EMPTY = new byte[]{0, 0, 0, 0};

    public static int getBitsForMax(long value) {
        if (value < 0L) {
            throw new IAE("maxValue[%s] must be positive", new Object[]{value});
        }
        int numBits = 0;
        long maxValue = 1L;
        for (int supportedSize : SUPPORTED_SIZES) {
            while (numBits < supportedSize && maxValue < 0x3FFFFFFFFFFFFFFFL) {
                numBits = (byte)(numBits + 1);
                maxValue *= 2L;
            }
            if (value > maxValue && maxValue < 0x3FFFFFFFFFFFFFFFL) continue;
            return supportedSize;
        }
        return 64;
    }

    public static int getSerializedSize(int bitsPerValue, int numValues) {
        return (bitsPerValue * numValues + 7) / 8 + 4;
    }

    public static int getNumValuesPerBlock(int bitsPerValue, int blockSize) {
        int ret = 1;
        while (VSizeLongSerde.getSerializedSize(bitsPerValue, ret) <= blockSize) {
            ret *= 2;
        }
        return ret / 2;
    }

    public static LongSerializer getSerializer(int longSize, OutputStream output) {
        switch (longSize) {
            case 1: {
                return new Size1Ser(output);
            }
            case 2: {
                return new Size2Ser(output);
            }
            case 4: {
                return new Mult4Ser(output, 0);
            }
            case 8: {
                return new Mult8Ser(output, 1);
            }
            case 12: {
                return new Mult4Ser(output, 1);
            }
            case 16: {
                return new Mult8Ser(output, 2);
            }
            case 20: {
                return new Mult4Ser(output, 2);
            }
            case 24: {
                return new Mult8Ser(output, 3);
            }
            case 32: {
                return new Mult8Ser(output, 4);
            }
            case 40: {
                return new Mult8Ser(output, 5);
            }
            case 48: {
                return new Mult8Ser(output, 6);
            }
            case 56: {
                return new Mult8Ser(output, 7);
            }
            case 64: {
                return new Mult8Ser(output, 8);
            }
        }
        throw new IAE("Unsupported size %s", new Object[]{longSize});
    }

    public static LongSerializer getSerializer(int longSize, ByteBuffer buffer, int bufferOffset) {
        switch (longSize) {
            case 1: {
                return new Size1Ser(buffer, bufferOffset);
            }
            case 2: {
                return new Size2Ser(buffer, bufferOffset);
            }
            case 4: {
                return new Mult4Ser(buffer, bufferOffset, 0);
            }
            case 8: {
                return new Mult8Ser(buffer, bufferOffset, 1);
            }
            case 12: {
                return new Mult4Ser(buffer, bufferOffset, 1);
            }
            case 16: {
                return new Mult8Ser(buffer, bufferOffset, 2);
            }
            case 20: {
                return new Mult4Ser(buffer, bufferOffset, 2);
            }
            case 24: {
                return new Mult8Ser(buffer, bufferOffset, 3);
            }
            case 32: {
                return new Mult8Ser(buffer, bufferOffset, 4);
            }
            case 40: {
                return new Mult8Ser(buffer, bufferOffset, 5);
            }
            case 48: {
                return new Mult8Ser(buffer, bufferOffset, 6);
            }
            case 56: {
                return new Mult8Ser(buffer, bufferOffset, 7);
            }
            case 64: {
                return new Mult8Ser(buffer, bufferOffset, 8);
            }
        }
        throw new IAE("Unsupported size %s", new Object[]{longSize});
    }

    public static LongDeserializer getDeserializer(int longSize, ByteBuffer fromBuffer, int bufferOffset) {
        ByteBuffer buffer = fromBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        switch (longSize) {
            case 1: {
                return new Size1Des(buffer, bufferOffset);
            }
            case 2: {
                return new Size2Des(buffer, bufferOffset);
            }
            case 4: {
                return new Size4Des(buffer, bufferOffset);
            }
            case 8: {
                return new Size8Des(buffer, bufferOffset);
            }
            case 12: {
                return new Size12Des(buffer, bufferOffset);
            }
            case 16: {
                return new Size16Des(buffer, bufferOffset);
            }
            case 20: {
                return new Size20Des(buffer, bufferOffset);
            }
            case 24: {
                return new Size24Des(buffer, bufferOffset);
            }
            case 32: {
                return new Size32Des(buffer, bufferOffset);
            }
            case 40: {
                return new Size40Des(buffer, bufferOffset);
            }
            case 48: {
                return new Size48Des(buffer, bufferOffset);
            }
            case 56: {
                return new Size56Des(buffer, bufferOffset);
            }
            case 64: {
                return new Size64Des(buffer, bufferOffset);
            }
        }
        throw new IAE("Unsupported size %s", new Object[]{longSize});
    }

    private static final class Size64Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size64Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + (index << 3));
        }
    }

    private static final class Size56Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size56Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + index * 7) >>> 8;
        }
    }

    private static final class Size48Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size48Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + index * 6) >>> 16;
        }
    }

    private static final class Size40Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size40Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + index * 5) >>> 24;
        }
    }

    private static final class Size32Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size32Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return (long)this.buffer.getInt(this.offset + (index << 2)) & 0xFFFFFFFFL;
        }
    }

    private static final class Size24Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size24Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getInt(this.offset + index * 3) >>> 8;
        }
    }

    private static final class Size20Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size20Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = ((index + 1 & 1) << 2) + 8;
            int offset = index * 5 >> 1;
            return this.buffer.getInt(this.offset + offset) >> shift & 0xFFFFF;
        }
    }

    private static final class Size16Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size16Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getShort(this.offset + (index << 1)) & 0xFFFF;
        }
    }

    private static final class Size12Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size12Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = (index + 1 & 1) << 2;
            int offset = index * 3 >> 1;
            return this.buffer.getShort(this.offset + offset) >> shift & 0xFFF;
        }
    }

    private static final class Size8Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size8Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.get(this.offset + index) & 0xFF;
        }
    }

    private static final class Size4Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size4Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = (index + 1 & 1) << 2;
            return this.buffer.get(this.offset + (index >> 1)) >> shift & 0xF;
        }
    }

    private static final class Size2Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size2Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = 6 - ((index & 3) << 1);
            return this.buffer.get(this.offset + (index >> 2)) >> shift & 3;
        }
    }

    private static final class Size1Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size1Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = 7 - (index & 7);
            return this.buffer.get(this.offset + (index >> 3)) >> shift & 1;
        }
    }

    public static interface LongDeserializer {
        public long get(int var1);
    }

    private static final class Mult8Ser
    implements LongSerializer {
        OutputStream output;
        ByteBuffer buffer;
        int numBytes;
        private boolean closed = false;

        public Mult8Ser(OutputStream output, int numBytes) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(1);
            this.numBytes = numBytes;
        }

        public Mult8Ser(ByteBuffer buffer, int offset, int numBytes) {
            this.buffer = buffer;
            this.buffer.position(offset);
            this.numBytes = numBytes;
        }

        @Override
        public void write(long value) throws IOException {
            for (int i = this.numBytes - 1; i >= 0; --i) {
                this.buffer.put((byte)(value >>> i * 8));
                if (this.output == null) continue;
                this.output.write(this.buffer.array());
                this.buffer.position(0);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.output != null) {
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    private static final class Mult4Ser
    implements LongSerializer {
        OutputStream output = null;
        ByteBuffer buffer;
        int numBytes;
        byte curByte = 0;
        boolean first = true;
        private boolean closed = false;

        public Mult4Ser(OutputStream output, int numBytes) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(numBytes * 2 + 1);
            this.numBytes = numBytes;
        }

        public Mult4Ser(ByteBuffer buffer, int offset, int numBytes) {
            this.buffer = buffer;
            this.buffer.position(offset);
            this.numBytes = numBytes;
        }

        @Override
        public void write(long value) throws IOException {
            int shift = 0;
            if (this.first) {
                shift = 4;
                this.curByte = (byte)value;
                this.first = false;
            } else {
                this.curByte = (byte)((long)(this.curByte << 4) | value >> (this.numBytes << 3) & 0xFL);
                this.buffer.put(this.curByte);
                this.first = true;
            }
            for (int i = this.numBytes - 1; i >= 0; --i) {
                this.buffer.put((byte)(value >>> i * 8 + shift));
            }
            if (!this.buffer.hasRemaining() && this.output != null) {
                this.output.write(this.buffer.array());
                this.buffer.rewind();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.first) {
                this.buffer.put((byte)(this.curByte << 4));
            }
            if (this.output != null) {
                this.output.write(this.buffer.array(), 0, this.buffer.position());
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    private static final class Size2Ser
    implements LongSerializer {
        OutputStream output = null;
        ByteBuffer buffer;
        byte curByte = 0;
        int count = 0;
        private boolean closed = false;

        public Size2Ser(OutputStream output) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(1);
        }

        public Size2Ser(ByteBuffer buffer, int offset) {
            this.buffer = buffer;
            this.buffer.position(offset);
        }

        @Override
        public void write(long value) throws IOException {
            if (this.count == 8) {
                this.buffer.put(this.curByte);
                this.count = 0;
                if (!this.buffer.hasRemaining() && this.output != null) {
                    this.output.write(this.buffer.array());
                    this.buffer.rewind();
                }
            }
            this.curByte = (byte)((long)(this.curByte << 2) | value & 3L);
            this.count += 2;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.buffer.put((byte)(this.curByte << 8 - this.count));
            if (this.output != null) {
                this.output.write(this.buffer.array());
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    private static final class Size1Ser
    implements LongSerializer {
        OutputStream output = null;
        ByteBuffer buffer;
        byte curByte = 0;
        int count = 0;
        private boolean closed = false;

        public Size1Ser(OutputStream output) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(1);
        }

        public Size1Ser(ByteBuffer buffer, int offset) {
            this.buffer = buffer;
            this.buffer.position(offset);
        }

        @Override
        public void write(long value) throws IOException {
            if (this.count == 8) {
                this.buffer.put(this.curByte);
                this.count = 0;
                if (!this.buffer.hasRemaining() && this.output != null) {
                    this.output.write(this.buffer.array());
                    this.buffer.rewind();
                }
            }
            this.curByte = (byte)((long)(this.curByte << 1) | value & 1L);
            ++this.count;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.buffer.put((byte)(this.curByte << 8 - this.count));
            if (this.output != null) {
                this.output.write(this.buffer.array());
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    public static interface LongSerializer
    extends Closeable {
        public void write(long var1) throws IOException;
    }
}

