/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.io.Channels;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.IndexIO;
import io.druid.segment.data.ColumnarMultiIntsSerializer;
import io.druid.segment.data.CompressedColumnarIntsSerializer;
import io.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import io.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class V3CompressedVSizeColumnarMultiIntsSerializer
extends ColumnarMultiIntsSerializer {
    private static final byte VERSION = 3;
    private final CompressedColumnarIntsSerializer offsetWriter;
    private final CompressedVSizeColumnarIntsSerializer valueWriter;
    private int offset;
    private boolean lastOffsetWritten = false;

    public static V3CompressedVSizeColumnarMultiIntsSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, int maxValue, CompressionStrategy compression) {
        return new V3CompressedVSizeColumnarMultiIntsSerializer(new CompressedColumnarIntsSerializer(segmentWriteOutMedium, filenameBase, 16384, IndexIO.BYTE_ORDER, compression), new CompressedVSizeColumnarIntsSerializer(segmentWriteOutMedium, filenameBase, maxValue, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(maxValue), IndexIO.BYTE_ORDER, compression));
    }

    V3CompressedVSizeColumnarMultiIntsSerializer(CompressedColumnarIntsSerializer offsetWriter, CompressedVSizeColumnarIntsSerializer valueWriter) {
        this.offsetWriter = offsetWriter;
        this.valueWriter = valueWriter;
        this.offset = 0;
    }

    @Override
    public void open() throws IOException {
        this.offsetWriter.open();
        this.valueWriter.open();
    }

    @Override
    protected void addValues(IntList vals) throws IOException {
        if (this.lastOffsetWritten) {
            throw new IllegalStateException("written out already");
        }
        if (vals == null) {
            vals = IntLists.EMPTY_LIST;
        }
        this.offsetWriter.add(this.offset);
        for (int i = 0; i < vals.size(); ++i) {
            this.valueWriter.add(vals.getInt(i));
        }
        this.offset += vals.size();
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeLastOffset();
        return 1L + this.offsetWriter.getSerializedSize() + this.valueWriter.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeLastOffset();
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap(new byte[]{3}));
        this.offsetWriter.writeTo(channel, smoosher);
        this.valueWriter.writeTo(channel, smoosher);
    }

    private void writeLastOffset() throws IOException {
        if (!this.lastOffsetWritten) {
            this.offsetWriter.add(this.offset);
            this.lastOffsetWritten = true;
        }
    }
}

