/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.data.IndexedInts;

public final class SingleIndexedInt
implements IndexedInts {
    private static final int CACHE_SIZE = 128;
    private static final SingleIndexedInt[] CACHE = new SingleIndexedInt[128];
    private final int value;

    private SingleIndexedInt(int value) {
        this.value = value;
    }

    public static SingleIndexedInt of(int value) {
        if (value >= 0 && value < 128) {
            return CACHE[value];
        }
        return new SingleIndexedInt(value);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int get(int i) {
        if (i != 0) {
            throw new IllegalArgumentException(i + " != 0");
        }
        return this.value;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    static {
        for (int i = 0; i < 128; ++i) {
            SingleIndexedInt.CACHE[i] = new SingleIndexedInt(i);
        }
    }
}

