/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Preconditions;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.data.IndexedInts;

public class RangeIndexedInts
implements IndexedInts {
    private static final int CACHE_LIMIT = 8;
    private static final RangeIndexedInts[] CACHE = new RangeIndexedInts[8];
    private final int size;

    private RangeIndexedInts(int size) {
        this.size = size;
    }

    public static RangeIndexedInts create(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size >= 0");
        if (size < 8) {
            return CACHE[size];
        }
        return new RangeIndexedInts(size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return index;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    static {
        for (int i = 0; i < 8; ++i) {
            RangeIndexedInts.CACHE[i] = new RangeIndexedInts(i);
        }
    }
}

