/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.writeout.WriteOutBytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;

public interface ObjectStrategy<T>
extends Comparator<T> {
    public Class<? extends T> getClazz();

    public T fromByteBuffer(ByteBuffer var1, int var2);

    public byte[] toBytes(T var1);

    default public T fromByteBufferWithSize(ByteBuffer buffer) {
        int size = buffer.getInt();
        ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
        bufferToUse.limit(bufferToUse.position() + size);
        buffer.position(bufferToUse.limit());
        return this.fromByteBuffer(bufferToUse, size);
    }

    default public void writeTo(T val, WriteOutBytes out) throws IOException {
        out.write(this.toBytes(val));
    }
}

