/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.writeout.WriteOutBytes;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LongsLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final ByteBuffer orderBuffer;
    private final ByteOrder order;
    private ByteBuffer outBuffer = null;
    private OutputStream outStream = null;

    public LongsLongEncodingWriter(ByteOrder order) {
        this.order = order;
        this.orderBuffer = ByteBuffer.allocate(8);
        this.orderBuffer.order(order);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.outStream = null;
        this.outBuffer = buffer;
        this.outBuffer.order(this.order);
    }

    @Override
    public void setOutputStream(WriteOutBytes output) {
        this.outBuffer = null;
        this.outStream = output;
    }

    @Override
    public void write(long value) throws IOException {
        if (this.outBuffer != null) {
            this.outBuffer.putLong(value);
        }
        if (this.outStream != null) {
            this.orderBuffer.rewind();
            this.orderBuffer.putLong(value);
            this.outStream.write(this.orderBuffer.array());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void putMeta(ByteBuffer metaOut, CompressionStrategy strategy) throws IOException {
        metaOut.put(strategy.getId());
    }

    @Override
    public int metaSize() {
        return 1;
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return bytesPerBlock / 8;
    }

    @Override
    public int getNumBytes(int values) {
        return values * 8;
    }
}

