/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.math.LongMath;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.data.BlockLayoutColumnarLongsSerializer;
import io.druid.segment.data.ColumnarLongsSerializer;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.DeltaLongEncodingWriter;
import io.druid.segment.data.EntireLayoutColumnarLongsSerializer;
import io.druid.segment.data.LongsLongEncodingWriter;
import io.druid.segment.data.TableLongEncodingWriter;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class IntermediateColumnarLongsSerializer
implements ColumnarLongsSerializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder order;
    private final CompressionStrategy compression;
    private LongList tempOut = null;
    private int numInserted = 0;
    private final Long2IntMap uniqueValues = new Long2IntOpenHashMap();
    private final LongList valuesAddedInOrder = new LongArrayList();
    private long maxVal = Long.MIN_VALUE;
    private long minVal = Long.MAX_VALUE;
    private ColumnarLongsSerializer delegate;

    IntermediateColumnarLongsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder order, CompressionStrategy compression) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.order = order;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.tempOut = new LongArrayList();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        if (this.delegate != null) {
            throw new IllegalStateException("written out already");
        }
        this.tempOut.add(value);
        ++this.numInserted;
        if (this.uniqueValues.size() <= 256 && !this.uniqueValues.containsKey(value)) {
            this.uniqueValues.put(value, this.uniqueValues.size());
            this.valuesAddedInOrder.add(value);
        }
        if (value > this.maxVal) {
            this.maxVal = value;
        }
        if (value < this.minVal) {
            this.minVal = value;
        }
    }

    private void makeDelegate() throws IOException {
        long delta;
        if (this.delegate != null) {
            return;
        }
        try {
            delta = LongMath.checkedSubtract((long)this.maxVal, (long)this.minVal);
        }
        catch (ArithmeticException e) {
            delta = -1L;
        }
        CompressionFactory.LongEncodingWriter writer = this.uniqueValues.size() <= 256 ? new TableLongEncodingWriter(this.uniqueValues, this.valuesAddedInOrder) : (delta != -1L && delta != Long.MAX_VALUE ? new DeltaLongEncodingWriter(this.minVal, delta) : new LongsLongEncodingWriter(this.order));
        this.delegate = this.compression == CompressionStrategy.NONE ? new EntireLayoutColumnarLongsSerializer(this.segmentWriteOutMedium, writer) : new BlockLayoutColumnarLongsSerializer(this.segmentWriteOutMedium, this.filenameBase, this.order, writer, this.compression);
        this.delegate.open();
        for (int i = 0; i < this.tempOut.size(); ++i) {
            this.delegate.add(this.tempOut.getLong(i));
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.makeDelegate();
        return this.delegate.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.makeDelegate();
        this.delegate.writeTo(channel, smoosher);
    }
}

