/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import io.druid.java.util.common.StringUtils;
import io.druid.segment.data.ColumnarLongs;
import io.druid.segment.data.CompressionFactory;

public class EntireLayoutColumnarLongsSupplier
implements Supplier<ColumnarLongs> {
    private final int totalSize;
    private final CompressionFactory.LongEncodingReader reader;

    public EntireLayoutColumnarLongsSupplier(int totalSize, CompressionFactory.LongEncodingReader reader) {
        this.totalSize = totalSize;
        this.reader = reader;
    }

    public ColumnarLongs get() {
        return new EntireLayoutColumnarLongs();
    }

    private class EntireLayoutColumnarLongs
    implements ColumnarLongs {
        private EntireLayoutColumnarLongs() {
        }

        @Override
        public int size() {
            return EntireLayoutColumnarLongsSupplier.this.totalSize;
        }

        @Override
        public long get(int index) {
            return EntireLayoutColumnarLongsSupplier.this.reader.read(index);
        }

        @Override
        public void fill(int index, long[] toFill) {
            if (EntireLayoutColumnarLongsSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format((String)"Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", (Object[])new Object[]{toFill.length, index, EntireLayoutColumnarLongsSupplier.this.totalSize}));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        public String toString() {
            return "EntireCompressedColumnarLongs_Anonymous{, totalSize=" + EntireLayoutColumnarLongsSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
        }
    }
}

