/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.data.ColumnarLongsSerializer;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.serde.MetaSerdeHelper;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import io.druid.segment.writeout.WriteOutBytes;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class EntireLayoutColumnarLongsSerializer
implements ColumnarLongsSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarLongsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeSomething(CompressionFactory.longEncodingWriter(x -> x.writer, x -> CompressionStrategy.NONE));
    private final CompressionFactory.LongEncodingWriter writer;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    EntireLayoutColumnarLongsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, CompressionFactory.LongEncodingWriter writer) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.writer = writer;
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.writer.setOutputStream(this.valuesOut);
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        this.writer.write(value);
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writer.flush();
        return (long)metaSerdeHelper.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.flush();
        metaSerdeHelper.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

