/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.data.ColumnarFloatsSerializer;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.serde.MetaSerdeHelper;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import io.druid.segment.writeout.WriteOutBytes;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class EntireLayoutColumnarFloatsSerializer
implements ColumnarFloatsSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarFloatsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeByte(x -> CompressionStrategy.NONE.getId());
    private final boolean isLittleEndian;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    EntireLayoutColumnarFloatsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder order) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.isLittleEndian = order.equals(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(float value) throws IOException {
        int valueBits = Float.floatToRawIntBits(value);
        if (this.isLittleEndian) {
            valueBits = Integer.reverseBytes(valueBits);
        }
        this.valuesOut.writeInt(valueBits);
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        return (long)metaSerdeHelper.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        metaSerdeHelper.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

