/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import io.druid.segment.data.ColumnarDoubles;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

public class EntireLayoutColumnarDoublesSupplier
implements Supplier<ColumnarDoubles> {
    private final int totalSize;
    private final DoubleBuffer buffer;

    public EntireLayoutColumnarDoublesSupplier(int totalSize, ByteBuffer fromBuffer, ByteOrder byteOrder) {
        this.totalSize = totalSize;
        this.buffer = fromBuffer.asReadOnlyBuffer().order(byteOrder).asDoubleBuffer();
    }

    public ColumnarDoubles get() {
        return new EntireLayoutColumnarDoubles();
    }

    private class EntireLayoutColumnarDoubles
    implements ColumnarDoubles {
        private EntireLayoutColumnarDoubles() {
        }

        @Override
        public int size() {
            return EntireLayoutColumnarDoublesSupplier.this.totalSize;
        }

        @Override
        public double get(int index) {
            return EntireLayoutColumnarDoublesSupplier.this.buffer.get(EntireLayoutColumnarDoublesSupplier.this.buffer.position() + index);
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "EntireCompressedColumnarDoubles_Anonymous{, totalSize=" + EntireLayoutColumnarDoublesSupplier.this.totalSize + '}';
        }
    }
}

