/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.collections.ResourceHolder;
import io.druid.segment.CompressedPools;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.ObjectStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DecompressingByteBufferObjectStrategy
implements ObjectStrategy<ResourceHolder<ByteBuffer>> {
    private final ByteOrder order;
    private final CompressionStrategy.Decompressor decompressor;

    DecompressingByteBufferObjectStrategy(ByteOrder order, CompressionStrategy compression) {
        this.order = order;
        this.decompressor = compression.getDecompressor();
    }

    @Override
    public Class<? extends ResourceHolder<ByteBuffer>> getClazz() {
        return ResourceHolder.class;
    }

    @Override
    public ResourceHolder<ByteBuffer> fromByteBuffer(ByteBuffer buffer, int numBytes) {
        final ResourceHolder<ByteBuffer> bufHolder = CompressedPools.getByteBuf(this.order);
        final ByteBuffer buf = (ByteBuffer)bufHolder.get();
        buf.clear();
        this.decompressor.decompress(buffer, numBytes, buf);
        buf.limit(buf.capacity());
        return new ResourceHolder<ByteBuffer>(){

            public ByteBuffer get() {
                return buf;
            }

            public void close() {
                bufHolder.close();
            }
        };
    }

    @Override
    public int compare(ResourceHolder<ByteBuffer> o1, ResourceHolder<ByteBuffer> o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toBytes(ResourceHolder<ByteBuffer> holder) {
        throw new UnsupportedOperationException();
    }
}

