/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ConciseBitmapFactory;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import io.druid.extendedset.intset.ImmutableConciseSet;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ObjectStrategy;
import java.nio.ByteBuffer;

public class ConciseBitmapSerdeFactory
implements BitmapSerdeFactory {
    private static final ObjectStrategy<ImmutableBitmap> objectStrategy = new ImmutableConciseSetObjectStrategy();
    private static final BitmapFactory bitmapFactory = new ConciseBitmapFactory();

    @Override
    public ObjectStrategy<ImmutableBitmap> getObjectStrategy() {
        return objectStrategy;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return bitmapFactory;
    }

    public String toString() {
        return "ConciseBitmapSerdeFactory{}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ConciseBitmapSerdeFactory;
    }

    public int hashCode() {
        return 0;
    }

    private static class ImmutableConciseSetObjectStrategy
    implements ObjectStrategy<ImmutableBitmap> {
        private ImmutableConciseSetObjectStrategy() {
        }

        @Override
        public Class<ImmutableBitmap> getClazz() {
            return ImmutableBitmap.class;
        }

        @Override
        public WrappedImmutableConciseBitmap fromByteBuffer(ByteBuffer buffer, int numBytes) {
            buffer.limit(buffer.position() + numBytes);
            return new WrappedImmutableConciseBitmap(new ImmutableConciseSet(buffer));
        }

        @Override
        public byte[] toBytes(ImmutableBitmap val) {
            if (val == null || val.isEmpty()) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableBitmap o1, ImmutableBitmap o2) {
            throw new UnsupportedOperationException();
        }
    }
}

