/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.StringUtils;
import io.druid.segment.data.BlockLayoutColumnarDoublesSerializer;
import io.druid.segment.data.BlockLayoutColumnarDoublesSupplier;
import io.druid.segment.data.BlockLayoutColumnarFloatsSerializer;
import io.druid.segment.data.BlockLayoutColumnarFloatsSupplier;
import io.druid.segment.data.BlockLayoutColumnarLongsSerializer;
import io.druid.segment.data.BlockLayoutColumnarLongsSupplier;
import io.druid.segment.data.ColumnarDoubles;
import io.druid.segment.data.ColumnarDoublesSerializer;
import io.druid.segment.data.ColumnarFloats;
import io.druid.segment.data.ColumnarFloatsSerializer;
import io.druid.segment.data.ColumnarLongs;
import io.druid.segment.data.ColumnarLongsSerializer;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.DeltaLongEncodingReader;
import io.druid.segment.data.EntireLayoutColumnarDoublesSerializer;
import io.druid.segment.data.EntireLayoutColumnarDoublesSupplier;
import io.druid.segment.data.EntireLayoutColumnarFloatsSerializer;
import io.druid.segment.data.EntireLayoutColumnarFloatsSupplier;
import io.druid.segment.data.EntireLayoutColumnarLongsSerializer;
import io.druid.segment.data.EntireLayoutColumnarLongsSupplier;
import io.druid.segment.data.IntermediateColumnarLongsSerializer;
import io.druid.segment.data.LongsLongEncodingReader;
import io.druid.segment.data.LongsLongEncodingWriter;
import io.druid.segment.data.TableLongEncodingReader;
import io.druid.segment.serde.MetaSerdeHelper;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import io.druid.segment.writeout.WriteOutBytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.function.Function;

public class CompressionFactory {
    public static final LongEncodingStrategy DEFAULT_LONG_ENCODING_STRATEGY = LongEncodingStrategy.LONGS;
    public static final LongEncodingFormat LEGACY_LONG_ENCODING_FORMAT = LongEncodingFormat.LONGS;
    public static final byte DELTA_ENCODING_VERSION = 1;
    public static final byte TABLE_ENCODING_VERSION = 1;
    public static final int MAX_TABLE_SIZE = 256;
    private static byte FLAG_BOUND = (byte)-2;
    private static int FLAG_VALUE = 126;

    private CompressionFactory() {
    }

    public static boolean hasEncodingFlag(byte strategyId) {
        return strategyId < FLAG_BOUND;
    }

    public static byte setEncodingFlag(byte strategyId) {
        return CompressionFactory.hasEncodingFlag(strategyId) ? strategyId : (byte)(strategyId - FLAG_VALUE);
    }

    public static byte clearEncodingFlag(byte strategyId) {
        return CompressionFactory.hasEncodingFlag(strategyId) ? (byte)(strategyId + FLAG_VALUE) : strategyId;
    }

    static <T> MetaSerdeHelper.FieldWriter<T> longEncodingWriter(final Function<T, LongEncodingWriter> getWriter, final Function<T, CompressionStrategy> getCompressionStrategy) {
        return new MetaSerdeHelper.FieldWriter<T>(){

            @Override
            public void writeTo(ByteBuffer buffer, T x) throws IOException {
                ((LongEncodingWriter)getWriter.apply(x)).putMeta(buffer, (CompressionStrategy)((Object)getCompressionStrategy.apply(x)));
            }

            @Override
            public int size(T x) {
                return ((LongEncodingWriter)getWriter.apply(x)).metaSize();
            }
        };
    }

    public static Supplier<ColumnarLongs> getLongSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, LongEncodingFormat encodingFormat, CompressionStrategy strategy) {
        if (strategy == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarLongsSupplier(totalSize, encodingFormat.getReader(fromBuffer, order));
        }
        return new BlockLayoutColumnarLongsSupplier(totalSize, sizePer, fromBuffer, order, encodingFormat.getReader(fromBuffer, order), strategy);
    }

    public static ColumnarLongsSerializer getLongSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder order, LongEncodingStrategy encodingStrategy, CompressionStrategy compressionStrategy) {
        if (encodingStrategy == LongEncodingStrategy.AUTO) {
            return new IntermediateColumnarLongsSerializer(segmentWriteOutMedium, filenameBase, order, compressionStrategy);
        }
        if (encodingStrategy == LongEncodingStrategy.LONGS) {
            if (compressionStrategy == CompressionStrategy.NONE) {
                return new EntireLayoutColumnarLongsSerializer(segmentWriteOutMedium, new LongsLongEncodingWriter(order));
            }
            return new BlockLayoutColumnarLongsSerializer(segmentWriteOutMedium, filenameBase, order, new LongsLongEncodingWriter(order), compressionStrategy);
        }
        throw new IAE("unknown encoding strategy : %s", new Object[]{encodingStrategy.toString()});
    }

    public static Supplier<ColumnarFloats> getFloatSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionStrategy strategy) {
        if (strategy == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarFloatsSupplier(totalSize, fromBuffer, order);
        }
        return new BlockLayoutColumnarFloatsSupplier(totalSize, sizePer, fromBuffer, order, strategy);
    }

    public static ColumnarFloatsSerializer getFloatSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder order, CompressionStrategy compressionStrategy) {
        if (compressionStrategy == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarFloatsSerializer(segmentWriteOutMedium, order);
        }
        return new BlockLayoutColumnarFloatsSerializer(segmentWriteOutMedium, filenameBase, order, compressionStrategy);
    }

    public static Supplier<ColumnarDoubles> getDoubleSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressionStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return new EntireLayoutColumnarDoublesSupplier(totalSize, fromBuffer, byteOrder);
            }
        }
        return new BlockLayoutColumnarDoublesSupplier(totalSize, sizePer, fromBuffer, byteOrder, strategy);
    }

    public static ColumnarDoublesSerializer getDoubleSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression) {
        if (compression == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarDoublesSerializer(segmentWriteOutMedium, byteOrder);
        }
        return new BlockLayoutColumnarDoublesSerializer(segmentWriteOutMedium, filenameBase, byteOrder, compression);
    }

    public static interface LongEncodingReader {
        public void setBuffer(ByteBuffer var1);

        public long read(int var1);

        public LongEncodingReader duplicate();
    }

    public static interface LongEncodingWriter {
        public void setBuffer(ByteBuffer var1);

        public void setOutputStream(WriteOutBytes var1);

        public void write(long var1) throws IOException;

        public void flush() throws IOException;

        public void putMeta(ByteBuffer var1, CompressionStrategy var2) throws IOException;

        public int metaSize();

        public int getBlockSize(int var1);

        public int getNumBytes(int var1);
    }

    public static enum LongEncodingFormat {
        DELTA(0){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new DeltaLongEncodingReader(buffer);
            }
        }
        ,
        TABLE(1){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new TableLongEncodingReader(buffer);
            }
        }
        ,
        LONGS(-1){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new LongsLongEncodingReader(buffer, order);
            }
        };

        final byte id;
        static final Map<Byte, LongEncodingFormat> idMap;

        private LongEncodingFormat(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public abstract LongEncodingReader getReader(ByteBuffer var1, ByteOrder var2);

        public static LongEncodingFormat forId(byte id) {
            return idMap.get(id);
        }

        static {
            idMap = Maps.newHashMap();
            for (LongEncodingFormat format : LongEncodingFormat.values()) {
                idMap.put(format.getId(), format);
            }
        }
    }

    public static enum LongEncodingStrategy {
        AUTO,
        LONGS;


        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase((String)this.name());
        }

        @JsonCreator
        public static LongEncodingStrategy fromString(String name) {
            return LongEncodingStrategy.valueOf(StringUtils.toUpperCase((String)name));
        }
    }
}

