/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.annotations.VisibleForTesting;
import io.druid.io.Channels;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.io.Closer;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.data.ColumnarInts;
import io.druid.segment.data.ColumnarMultiInts;
import io.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.WritableSupplier;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

public class CompressedVSizeColumnarMultiIntsSupplier
implements WritableSupplier<ColumnarMultiInts> {
    private static final byte version = 2;
    private final CompressedVSizeColumnarIntsSupplier offsetSupplier;
    private final CompressedVSizeColumnarIntsSupplier valueSupplier;

    private CompressedVSizeColumnarMultiIntsSupplier(CompressedVSizeColumnarIntsSupplier offsetSupplier, CompressedVSizeColumnarIntsSupplier valueSupplier) {
        this.offsetSupplier = offsetSupplier;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public long getSerializedSize() throws IOException {
        return 1L + this.offsetSupplier.getSerializedSize() + this.valueSupplier.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap(new byte[]{2}));
        this.offsetSupplier.writeTo(channel, smoosher);
        this.valueSupplier.writeTo(channel, smoosher);
    }

    public static CompressedVSizeColumnarMultiIntsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            CompressedVSizeColumnarIntsSupplier offsetSupplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, order);
            CompressedVSizeColumnarIntsSupplier valueSupplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, order);
            return new CompressedVSizeColumnarMultiIntsSupplier(offsetSupplier, valueSupplier);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    @VisibleForTesting
    public static CompressedVSizeColumnarMultiIntsSupplier fromIterable(Iterable<IndexedInts> objectsIterable, int maxValue, ByteOrder byteOrder, CompressionStrategy compression, Closer closer) {
        Iterator<IndexedInts> objects = objectsIterable.iterator();
        IntArrayList offsetList = new IntArrayList();
        IntArrayList values = new IntArrayList();
        int offset = 0;
        while (objects.hasNext()) {
            IndexedInts next = objects.next();
            offsetList.add(offset);
            for (int i = 0; i < next.size(); ++i) {
                values.add(next.get(i));
            }
            offset += next.size();
        }
        offsetList.add(offset);
        int offsetMax = offset;
        CompressedVSizeColumnarIntsSupplier headerSupplier = CompressedVSizeColumnarIntsSupplier.fromList((IntList)offsetList, offsetMax, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(offsetMax), byteOrder, compression, closer);
        CompressedVSizeColumnarIntsSupplier valuesSupplier = CompressedVSizeColumnarIntsSupplier.fromList((IntList)values, maxValue, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(maxValue), byteOrder, compression, closer);
        return new CompressedVSizeColumnarMultiIntsSupplier(headerSupplier, valuesSupplier);
    }

    public ColumnarMultiInts get() {
        return new CompressedVSizeColumnarMultiInts(this.offsetSupplier.get(), this.valueSupplier.get());
    }

    public static class CompressedVSizeColumnarMultiInts
    implements ColumnarMultiInts {
        private final ColumnarInts offsets;
        private final ColumnarInts values;

        CompressedVSizeColumnarMultiInts(ColumnarInts offsets, ColumnarInts values) {
            this.offsets = offsets;
            this.values = values;
        }

        @Override
        public void close() throws IOException {
            this.offsets.close();
            this.values.close();
        }

        @Override
        public Class<? extends IndexedInts> getClazz() {
            return IndexedInts.class;
        }

        @Override
        public int size() {
            return this.offsets.size() - 1;
        }

        @Override
        public IndexedInts get(int index) {
            final int offset = this.offsets.get(index);
            final int size = this.offsets.get(index + 1) - offset;
            return new IndexedInts(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public int get(int index) {
                    if (index >= size) {
                        throw new IAE("Index[%d] >= size[%d]", new Object[]{index, size});
                    }
                    return values.get(index + offset);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("values", values);
                }
            };
        }

        @Override
        public int indexOf(IndexedInts value) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }

        @Override
        public Iterator<IndexedInts> iterator() {
            return IndexedIterable.create(this).iterator();
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("offsets", this.offsets);
            inspector.visit("values", this.values);
        }
    }
}

