/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import io.druid.io.Channels;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.data.ColumnarFloats;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.serde.MetaSerdeHelper;
import io.druid.segment.serde.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class CompressedColumnarFloatsSupplier
implements Supplier<ColumnarFloats>,
Serializer {
    public static final byte LZF_VERSION = 1;
    public static final byte VERSION = 2;
    private static final MetaSerdeHelper<CompressedColumnarFloatsSupplier> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.totalSize).writeInt(x -> x.sizePer).writeByte(x -> x.compression.getId());
    private final int totalSize;
    private final int sizePer;
    private final ByteBuffer buffer;
    private final Supplier<ColumnarFloats> supplier;
    private final CompressionStrategy compression;

    CompressedColumnarFloatsSupplier(int totalSize, int sizePer, ByteBuffer buffer, Supplier<ColumnarFloats> supplier, CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.buffer = buffer;
        this.supplier = supplier;
        this.compression = compression;
    }

    public ColumnarFloats get() {
        return (ColumnarFloats)this.supplier.get();
    }

    @Override
    public long getSerializedSize() throws IOException {
        return (long)metaSerdeHelper.size(this) + (long)this.buffer.remaining();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        metaSerdeHelper.writeTo(channel, this);
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)this.buffer.asReadOnlyBuffer());
    }

    public static CompressedColumnarFloatsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressionStrategy compression = CompressionStrategy.LZF;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                compression = CompressionStrategy.forId(compressionId);
            }
            Supplier<ColumnarFloats> supplier = CompressionFactory.getFloatSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, compression);
            return new CompressedColumnarFloatsSupplier(totalSize, sizePer, buffer, supplier, compression);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }
}

