/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import io.druid.java.util.common.IAE;
import io.druid.segment.data.ColumnarDoubles;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CompressedColumnarDoublesSuppliers {
    public static final byte LZF_VERSION = 1;
    public static final byte VERSION = 2;

    private CompressedColumnarDoublesSuppliers() {
    }

    public static Supplier<ColumnarDoubles> fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressionStrategy compression = CompressionStrategy.LZF;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                compression = CompressionStrategy.forId(compressionId);
            }
            return CompressionFactory.getDoubleSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, compression);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }
}

