/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import io.druid.collections.ResourceHolder;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.segment.data.ColumnarDoubles;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.DecompressingByteBufferObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

public class BlockLayoutColumnarDoublesSupplier
implements Supplier<ColumnarDoubles> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseDoubleBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutColumnarDoublesSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressionStrategy strategy) {
        this.baseDoubleBuffers = GenericIndexed.read(fromBuffer, new DecompressingByteBufferObjectStrategy(byteOrder, strategy));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    public ColumnarDoubles get() {
        return new BlockLayoutColumnarDoubles();
    }

    private class BlockLayoutColumnarDoubles
    implements ColumnarDoubles {
        final Indexed<ResourceHolder<ByteBuffer>> resourceHolderIndexed;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        DoubleBuffer doubleBuffer;

        private BlockLayoutColumnarDoubles() {
            this.resourceHolderIndexed = BlockLayoutColumnarDoublesSupplier.this.baseDoubleBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarDoublesSupplier.this.totalSize;
        }

        @Override
        public double get(int index) {
            int bufferNum = index / BlockLayoutColumnarDoublesSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarDoublesSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.doubleBuffer.get(this.doubleBuffer.position() + bufferIndex);
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.resourceHolderIndexed.get(bufferNum);
            this.buffer = (ByteBuffer)this.holder.get();
            this.doubleBuffer = this.buffer.asDoubleBuffer();
            this.currIndex = bufferNum;
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }

        public String toString() {
            return "BlockCompressedColumnarDoubles_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutColumnarDoublesSupplier.this.sizePer + ", numChunks=" + this.resourceHolderIndexed.size() + ", totalSize=" + BlockLayoutColumnarDoublesSupplier.this.totalSize + '}';
        }
    }
}

