/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.java.util.common.io.Closer;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.data.ColumnarDoublesSerializer;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.serde.MetaSerdeHelper;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class BlockLayoutColumnarDoublesSerializer
implements ColumnarDoublesSerializer {
    private static final MetaSerdeHelper<BlockLayoutColumnarDoublesSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 8192).writeByte(x -> x.compression.getId());
    private final GenericIndexedWriter<ByteBuffer> flattener;
    private final CompressionStrategy compression;
    private int numInserted = 0;
    private ByteBuffer endBuffer;

    BlockLayoutColumnarDoublesSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression) {
        this.flattener = GenericIndexedWriter.ofCompressedByteBuffers(segmentWriteOutMedium, filenameBase, compression, 65536);
        this.compression = compression;
        CompressionStrategy.Compressor compressor = compression.getCompressor();
        Closer closer = segmentWriteOutMedium.getCloser();
        this.endBuffer = compressor.allocateInBuffer(65536, closer).order(byteOrder);
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public void add(double value) throws IOException {
        if (this.endBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write(this.endBuffer);
            this.endBuffer.clear();
        }
        this.endBuffer.putDouble(value);
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeEndBuffer();
        return (long)metaSerdeHelper.size(this) + this.flattener.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeEndBuffer();
        metaSerdeHelper.writeTo(channel, this);
        this.flattener.writeTo(channel, smoosher);
    }

    private void writeEndBuffer() throws IOException {
        if (this.endBuffer != null) {
            this.endBuffer.flip();
            if (this.endBuffer.remaining() > 0) {
                this.flattener.write(this.endBuffer);
            }
            this.endBuffer = null;
        }
    }
}

