/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.java.util.common.IAE;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.data.IndexedInts;
import it.unimi.dsi.fastutil.ints.IntArrays;

public final class ArrayBasedIndexedInts
implements IndexedInts {
    private static final ArrayBasedIndexedInts EMPTY = new ArrayBasedIndexedInts(IntArrays.EMPTY_ARRAY, 0);
    private final int[] expansion;
    private final int size;

    public static ArrayBasedIndexedInts of(int[] expansion) {
        if (expansion.length == 0) {
            return EMPTY;
        }
        return new ArrayBasedIndexedInts(expansion, expansion.length);
    }

    public static ArrayBasedIndexedInts of(int[] expansion, int size) {
        if (size == 0) {
            return EMPTY;
        }
        if (size < 0 || size > expansion.length) {
            throw new IAE("Size[%s] should be between 0 and %s", new Object[]{size, expansion.length});
        }
        return new ArrayBasedIndexedInts(expansion, size);
    }

    private ArrayBasedIndexedInts(int[] expansion, int size) {
        this.expansion = expansion;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
        }
        return this.expansion[index];
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

