/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DoubleWrappingDimensionSelector;
import io.druid.segment.FloatWrappingDimensionSelector;
import io.druid.segment.LongWrappingDimensionSelector;

public enum ValueType {
    FLOAT{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
            return new FloatWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }
    }
    ,
    DOUBLE{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
            return new DoubleWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }
    }
    ,
    LONG{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
            return new LongWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }
    }
    ,
    STRING,
    COMPLEX;


    public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
        throw new UnsupportedOperationException("Not a numeric value type: " + this.name());
    }

    public boolean isNumeric() {
        return ValueType.isNumeric(this);
    }

    @JsonCreator
    public static ValueType fromString(String name) {
        if (name == null) {
            return null;
        }
        return ValueType.valueOf(StringUtils.toUpperCase((String)name));
    }

    public static boolean isNumeric(ValueType type) {
        return type == LONG || type == FLOAT || type == DOUBLE;
    }
}

