/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.druid.java.util.common.Cacheable;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.Pair;
import io.druid.query.cache.CacheKeyBuilder;
import io.druid.query.dimension.DimensionSpec;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumn;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.virtual.VirtualizedColumnSelectorFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class VirtualColumns
implements Cacheable {
    public static final VirtualColumns EMPTY = new VirtualColumns((List<VirtualColumn>)ImmutableList.of(), (Map<String, VirtualColumn>)ImmutableMap.of(), (Map<String, VirtualColumn>)ImmutableMap.of());
    private final List<VirtualColumn> virtualColumns;
    private final Map<String, VirtualColumn> withDotSupport;
    private final Map<String, VirtualColumn> withoutDotSupport;

    public static Pair<String, String> splitColumnName(String columnName) {
        int i = columnName.indexOf(46);
        if (i < 0) {
            return Pair.of((Object)columnName, null);
        }
        return Pair.of((Object)columnName.substring(0, i), (Object)columnName.substring(i + 1));
    }

    @JsonCreator
    public static VirtualColumns create(List<VirtualColumn> virtualColumns) {
        if (virtualColumns == null || virtualColumns.isEmpty()) {
            return EMPTY;
        }
        HashMap withDotSupport = Maps.newHashMap();
        HashMap withoutDotSupport = Maps.newHashMap();
        for (VirtualColumn vc : virtualColumns) {
            if (Strings.isNullOrEmpty((String)vc.getOutputName())) {
                throw new IAE("Empty or null virtualColumn name", new Object[0]);
            }
            if (vc.getOutputName().equals("__time")) {
                throw new IAE("virtualColumn name[%s] not allowed", new Object[]{vc.getOutputName()});
            }
            if (withDotSupport.containsKey(vc.getOutputName()) || withoutDotSupport.containsKey(vc.getOutputName())) {
                throw new IAE("Duplicate virtualColumn name[%s]", new Object[]{vc.getOutputName()});
            }
            if (vc.usesDotNotation()) {
                withDotSupport.put(vc.getOutputName(), vc);
                continue;
            }
            withoutDotSupport.put(vc.getOutputName(), vc);
        }
        return new VirtualColumns((List<VirtualColumn>)ImmutableList.copyOf(virtualColumns), withDotSupport, withoutDotSupport);
    }

    public static VirtualColumns nullToEmpty(@Nullable VirtualColumns virtualColumns) {
        return virtualColumns == null ? EMPTY : virtualColumns;
    }

    private VirtualColumns(List<VirtualColumn> virtualColumns, Map<String, VirtualColumn> withDotSupport, Map<String, VirtualColumn> withoutDotSupport) {
        this.virtualColumns = virtualColumns;
        this.withDotSupport = withDotSupport;
        this.withoutDotSupport = withoutDotSupport;
        for (VirtualColumn virtualColumn : virtualColumns) {
            this.detectCycles(virtualColumn, null);
        }
    }

    public boolean exists(String columnName) {
        return this.getVirtualColumn(columnName) != null;
    }

    public VirtualColumn getVirtualColumn(String columnName) {
        VirtualColumn vc = this.withoutDotSupport.get(columnName);
        if (vc != null) {
            return vc;
        }
        String baseColumnName = (String)VirtualColumns.splitColumnName((String)columnName).lhs;
        return this.withDotSupport.get(baseColumnName);
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        VirtualColumn virtualColumn = this.getVirtualColumn(dimensionSpec.getDimension());
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{dimensionSpec.getDimension()});
        }
        DimensionSelector selector = virtualColumn.makeDimensionSelector(dimensionSpec, factory);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{columnName});
        }
        ColumnValueSelector<?> selector = virtualColumn.makeColumnValueSelector(columnName, factory);
        Preconditions.checkNotNull(selector, (Object)"selector");
        return selector;
    }

    public ColumnCapabilities getColumnCapabilities(String columnName) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn != null) {
            return (ColumnCapabilities)Preconditions.checkNotNull((Object)virtualColumn.capabilities(columnName), (String)"capabilities for column[%s]", (Object[])new Object[]{columnName});
        }
        return null;
    }

    public ColumnCapabilities getColumnCapabilitiesWithFallback(StorageAdapter adapter, String columnName) {
        ColumnCapabilities virtualColumnCapabilities = this.getColumnCapabilities(columnName);
        if (virtualColumnCapabilities != null) {
            return virtualColumnCapabilities;
        }
        return adapter.getColumnCapabilities(columnName);
    }

    @JsonValue
    public VirtualColumn[] getVirtualColumns() {
        return this.virtualColumns.toArray(new VirtualColumn[0]);
    }

    public ColumnSelectorFactory wrap(ColumnSelectorFactory baseFactory) {
        return new VirtualizedColumnSelectorFactory(baseFactory, this);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendCacheablesIgnoringOrder(this.virtualColumns).build();
    }

    private void detectCycles(VirtualColumn virtualColumn, Set<String> columnNames) {
        HashSet nextSet = columnNames == null ? Sets.newHashSet((Object[])new String[]{virtualColumn.getOutputName()}) : Sets.newHashSet(columnNames);
        for (String columnName : virtualColumn.requiredColumns()) {
            if (!nextSet.add(columnName)) {
                throw new IAE("Self-referential column[%s]", new Object[]{columnName});
            }
            VirtualColumn dependency = this.getVirtualColumn(columnName);
            if (dependency == null) continue;
            this.detectCycles(dependency, nextSet);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualColumns that = (VirtualColumns)o;
        return this.virtualColumns.equals(that.virtualColumns);
    }

    public int hashCode() {
        return this.virtualColumns.hashCode();
    }

    public String toString() {
        return this.virtualColumns.toString();
    }
}

