/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.data.input.impl.DimensionSchema;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Comparators;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DimensionSelectorUtils;
import io.druid.segment.IdLookup;
import io.druid.segment.data.ArrayBasedIndexedInts;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.TimeAndDimsHolder;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class StringDimensionIndexer
implements DimensionIndexer<Integer, int[], String> {
    private static final Function<Object, String> STRING_TRANSFORMER = o -> o != null ? o.toString() : null;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final DimensionDictionary dimLookup = new DimensionDictionary();
    private final DimensionSchema.MultiValueHandling multiValueHandling;
    private SortedDimensionDictionary sortedLookup;

    public StringDimensionIndexer(DimensionSchema.MultiValueHandling multiValueHandling) {
        this.multiValueHandling = multiValueHandling == null ? DimensionSchema.MultiValueHandling.ofDefault() : multiValueHandling;
    }

    @Override
    public int[] processRowValsToUnsortedEncodedKeyComponent(Object dimValues, boolean reportParseExceptions) {
        int[] encodedDimensionValues;
        int oldDictSize = this.dimLookup.size();
        if (dimValues == null) {
            this.dimLookup.add(null);
            encodedDimensionValues = null;
        } else if (dimValues instanceof List) {
            List dimValuesList = (List)dimValues;
            if (dimValuesList.isEmpty()) {
                this.dimLookup.add(null);
                encodedDimensionValues = EMPTY_INT_ARRAY;
            } else if (dimValuesList.size() == 1) {
                encodedDimensionValues = new int[]{this.dimLookup.add(STRING_TRANSFORMER.apply(dimValuesList.get(0)))};
            } else {
                String[] dimensionValues = new String[dimValuesList.size()];
                for (int i = 0; i < dimValuesList.size(); ++i) {
                    dimensionValues[i] = STRING_TRANSFORMER.apply(dimValuesList.get(i));
                }
                if (this.multiValueHandling.needSorting()) {
                    Arrays.sort(dimensionValues, Comparators.naturalNullsFirst());
                }
                int[] retVal = new int[dimensionValues.length];
                int prevId = -1;
                int pos = 0;
                for (String dimensionValue : dimensionValues) {
                    if (this.multiValueHandling != DimensionSchema.MultiValueHandling.SORTED_SET) {
                        retVal[pos++] = this.dimLookup.add(dimensionValue);
                        continue;
                    }
                    int index = this.dimLookup.add(dimensionValue);
                    if (index == prevId) continue;
                    int n = pos++;
                    int n2 = index;
                    retVal[n] = n2;
                    prevId = n2;
                }
                encodedDimensionValues = pos == retVal.length ? retVal : Arrays.copyOf(retVal, pos);
            }
        } else {
            encodedDimensionValues = new int[]{this.dimLookup.add(STRING_TRANSFORMER.apply(dimValues))};
        }
        if (oldDictSize != this.dimLookup.size()) {
            this.sortedLookup = null;
        }
        return encodedDimensionValues;
    }

    public Integer getSortedEncodedValueFromUnsorted(Integer unsortedIntermediateValue) {
        return this.sortedLookup().getSortedIdFromUnsortedId(unsortedIntermediateValue);
    }

    @Override
    public Integer getUnsortedEncodedValueFromSorted(Integer sortedIntermediateValue) {
        return this.sortedLookup().getUnsortedIdFromSortedId(sortedIntermediateValue);
    }

    @Override
    public Indexed<String> getSortedIndexedValues() {
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return StringDimensionIndexer.this.getCardinality();
            }

            @Override
            public String get(int index) {
                return StringDimensionIndexer.this.getActualValue(index, true);
            }

            @Override
            public int indexOf(String value) {
                int id = StringDimensionIndexer.this.getEncodedValue(value, false);
                return id < 0 ? -1 : StringDimensionIndexer.this.getSortedEncodedValueFromUnsorted(id);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    @Override
    public String getMinValue() {
        return this.dimLookup.getMinValue();
    }

    @Override
    public String getMaxValue() {
        return this.dimLookup.getMaxValue();
    }

    @Override
    public int getCardinality() {
        return this.dimLookup.size();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int retVal = Ints.compare((int)lhsLen, (int)rhsLen);
        for (int valsIndex = 0; retVal == 0 && valsIndex < lhsLen; ++valsIndex) {
            int lhsVal = lhs[valsIndex];
            int rhsVal = rhs[valsIndex];
            if (lhsVal == rhsVal) continue;
            String lhsValActual = this.getActualValue(lhsVal, false);
            String rhsValActual = this.getActualValue(rhsVal, false);
            if (lhsValActual != null && rhsValActual != null) {
                retVal = lhsValActual.compareTo(rhsValActual);
                continue;
            }
            if (!(lhsValActual == null ^ rhsValActual == null)) continue;
            retVal = lhsValActual == null ? -1 : 1;
        }
        return retVal;
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(int[] lhs, int[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(int[] key) {
        return Arrays.hashCode(key);
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final ExtractionFn extractionFn = spec.getExtractionFn();
        final int dimIndex = desc.getIndex();
        final int maxId = this.getCardinality();
        class IndexerDimensionSelector
        implements DimensionSelector,
        IdLookup {
            private int[] nullIdIntArray;

            IndexerDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                Object[] dims = currEntry.get().getDims();
                int[] indices = dimIndex < dims.length ? (int[])dims[dimIndex] : null;
                int[] row = null;
                int rowSize = 0;
                if (indices == null || indices.length == 0) {
                    int nullId = StringDimensionIndexer.this.getEncodedValue(null, false);
                    if (nullId > -1) {
                        if (this.nullIdIntArray == null) {
                            this.nullIdIntArray = new int[]{nullId};
                        }
                        row = this.nullIdIntArray;
                        rowSize = 1;
                    } else {
                        row = IntArrays.EMPTY_ARRAY;
                        rowSize = 0;
                    }
                }
                if (row == null && indices != null && indices.length > 0) {
                    row = indices;
                    rowSize = indices.length;
                }
                return ArrayBasedIndexedInts.of(row, rowSize);
            }

            @Override
            public ValueMatcher makeValueMatcher(final String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0 || value == null) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                Object[] dims = currEntry.get().getDims();
                                if (dimIndex >= dims.length) {
                                    return value == null;
                                }
                                int[] dimsInt = (int[])dims[dimIndex];
                                if (dimsInt == null || dimsInt.length == 0) {
                                    return value == null;
                                }
                                for (int id : dimsInt) {
                                    if (id != valueId) continue;
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                final BitSet predicateMatchingValueIds = DimensionSelectorUtils.makePredicateMatchingSet(this, predicate);
                final boolean matchNull = predicate.apply(null);
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        Object[] dims = currEntry.get().getDims();
                        if (dimIndex >= dims.length) {
                            return matchNull;
                        }
                        int[] dimsInt = (int[])dims[dimIndex];
                        if (dimsInt == null || dimsInt.length == 0) {
                            return matchNull;
                        }
                        for (int id : dimsInt) {
                            if (!predicateMatchingValueIds.get(id)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return maxId;
            }

            @Override
            public String lookupName(int id) {
                if (id >= maxId) {
                    throw new ISE("id[%d] >= maxId[%d]", new Object[]{id, maxId});
                }
                String strValue = StringDimensionIndexer.this.getActualValue(id, false);
                return extractionFn == null ? strValue : extractionFn.apply(strValue);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn != null) {
                    throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                }
                return StringDimensionIndexer.this.getEncodedValue(name, false);
            }

            @Override
            @Nullable
            public Object getObject() {
                IncrementalIndex.TimeAndDims key = currEntry.get();
                if (key == null) {
                    return null;
                }
                Object[] dims = key.getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return StringDimensionIndexer.this.convertUnsortedEncodedKeyComponentToActualArrayOrList((int[])dims[dimIndex], false);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDimensionSelector();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(desc.getName()), currEntry, desc);
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(int[] key, boolean asList) {
        if (key == null || key.length == 0) {
            return null;
        }
        if (key.length == 1) {
            String val = this.getActualValue(key[0], false);
            val = Strings.nullToEmpty((String)val);
            return val;
        }
        if (asList) {
            ArrayList<String> rowVals = new ArrayList<String>(key.length);
            for (int id : key) {
                String val = this.getActualValue(id, false);
                rowVals.add(Strings.nullToEmpty((String)val));
            }
            return rowVals;
        }
        String[] rowArray = new String[key.length];
        for (int i = 0; i < key.length; ++i) {
            String val = this.getActualValue(key[i], false);
            rowArray[i] = Strings.nullToEmpty((String)val);
        }
        return rowArray;
    }

    @Override
    public int[] convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(int[] key) {
        int[] sortedDimVals = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            sortedDimVals[i] = this.getSortedEncodedValueFromUnsorted(key[i]);
        }
        return sortedDimVals;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(int[] key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        for (int dimValIdx : key) {
            if (bitmapIndexes[dimValIdx] == null) {
                bitmapIndexes[dimValIdx] = factory.makeEmptyMutableBitmap();
            }
            bitmapIndexes[dimValIdx].add(rowNum);
        }
    }

    private SortedDimensionDictionary sortedLookup() {
        return this.sortedLookup == null ? (this.sortedLookup = this.dimLookup.sort()) : this.sortedLookup;
    }

    private String getActualValue(int intermediateValue, boolean idSorted) {
        if (idSorted) {
            return this.sortedLookup().getValueFromSortedId(intermediateValue);
        }
        return this.dimLookup.getValue(intermediateValue);
    }

    private int getEncodedValue(String fullValue, boolean idSorted) {
        int unsortedId = this.dimLookup.getId(fullValue);
        if (idSorted) {
            return this.sortedLookup().getSortedIdFromUnsortedId(unsortedId);
        }
        return unsortedId;
    }

    private static class SortedDimensionDictionary {
        private final List<String> sortedVals;
        private final int[] idToIndex;
        private final int[] indexToId;

        public SortedDimensionDictionary(List<String> idToValue, int length) {
            Object2IntRBTreeMap sortedMap = new Object2IntRBTreeMap();
            for (int id = 0; id < length; ++id) {
                sortedMap.put((Object)idToValue.get(id), id);
            }
            this.sortedVals = Lists.newArrayList((Iterable)sortedMap.keySet());
            this.idToIndex = new int[length];
            this.indexToId = new int[length];
            int index = 0;
            IntIterator iterator = sortedMap.values().iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextInt();
                this.idToIndex[id] = index;
                this.indexToId[index] = id;
                ++index;
            }
        }

        public int getUnsortedIdFromSortedId(int index) {
            return this.indexToId[index];
        }

        public int getSortedIdFromUnsortedId(int id) {
            return this.idToIndex[id];
        }

        public String getValueFromSortedId(int index) {
            return Strings.emptyToNull((String)this.sortedVals.get(index));
        }
    }

    private static class DimensionDictionary {
        private String minValue = null;
        private String maxValue = null;
        private final Object2IntMap<String> valueToId = new Object2IntOpenHashMap();
        private final List<String> idToValue = Lists.newArrayList();
        private final Object lock = new Object();

        public DimensionDictionary() {
            this.valueToId.defaultReturnValue(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getId(String value) {
            Object object = this.lock;
            synchronized (object) {
                return this.valueToId.getInt((Object)Strings.nullToEmpty((String)value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getValue(int id) {
            Object object = this.lock;
            synchronized (object) {
                return Strings.emptyToNull((String)this.idToValue.get(id));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.valueToId.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int add(String originalValue) {
            String value = Strings.nullToEmpty((String)originalValue);
            Object object = this.lock;
            synchronized (object) {
                int prev = this.valueToId.getInt((Object)value);
                if (prev >= 0) {
                    return prev;
                }
                int index = this.size();
                this.valueToId.put((Object)value, index);
                this.idToValue.add(value);
                this.minValue = this.minValue == null || this.minValue.compareTo(value) > 0 ? value : this.minValue;
                this.maxValue = this.maxValue == null || this.maxValue.compareTo(value) < 0 ? value : this.maxValue;
                return index;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getMinValue() {
            Object object = this.lock;
            synchronized (object) {
                return this.minValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getMaxValue() {
            Object object = this.lock;
            synchronized (object) {
                return this.maxValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedDimensionDictionary sort() {
            Object object = this.lock;
            synchronized (object) {
                return new SortedDimensionDictionary(this.idToValue, this.size());
            }
        }
    }
}

