/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.primitives.Ints;
import io.druid.data.input.impl.DimensionSchema;
import io.druid.segment.DimensionHandler;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.SegmentValidationException;
import io.druid.segment.StringDimensionIndexer;
import io.druid.segment.StringDimensionMergerV9;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class StringDimensionHandler
implements DimensionHandler<Integer, int[], String> {
    private final String dimensionName;
    private final DimensionSchema.MultiValueHandling multiValueHandling;

    public StringDimensionHandler(String dimensionName, DimensionSchema.MultiValueHandling multiValueHandling) {
        this.dimensionName = dimensionName;
        this.multiValueHandling = multiValueHandling;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionSchema.MultiValueHandling getMultivalueHandling() {
        return this.multiValueHandling;
    }

    @Override
    public int getLengthOfEncodedKeyComponent(int[] dimVals) {
        return dimVals.length;
    }

    @Override
    public int compareSortedEncodedKeyComponents(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int retVal = Ints.compare((int)lhsLen, (int)rhsLen);
        for (int valsIndex = 0; retVal == 0 && valsIndex < lhsLen; ++valsIndex) {
            retVal = Ints.compare((int)lhs[valsIndex], (int)rhs[valsIndex]);
        }
        return retVal;
    }

    @Override
    public void validateSortedEncodedKeyComponents(int[] lhs, int[] rhs, Indexed<String> lhsEncodings, Indexed<String> rhsEncodings) throws SegmentValidationException {
        int rhsLen;
        if (lhs == null || rhs == null) {
            if (lhs != null || rhs != null) {
                throw new SegmentValidationException("Expected nulls, found %s and %s", Arrays.toString(lhs), Arrays.toString(rhs));
            }
            return;
        }
        int lhsLen = Array.getLength(lhs);
        if (lhsLen != (rhsLen = Array.getLength(rhs))) {
            if (lhsLen == 0 && rhsLen == 1) {
                String dimValName = rhsEncodings.get(rhs[0]);
                if (dimValName == null) {
                    return;
                }
                throw new SegmentValidationException("Dim [%s] value [%s] is not null", this.dimensionName, dimValName);
            }
            if (rhsLen == 0 && lhsLen == 1) {
                String dimValName = lhsEncodings.get(lhs[0]);
                if (dimValName == null) {
                    return;
                }
                throw new SegmentValidationException("Dim [%s] value [%s] is not null", this.dimensionName, dimValName);
            }
            throw new SegmentValidationException("Dim [%s] value lengths not equal. Expected %d found %d", this.dimensionName, lhsLen, rhsLen);
        }
        for (int j = 0; j < Math.max(lhsLen, rhsLen); ++j) {
            String dim2ValName;
            int dIdex1 = lhsLen <= j ? -1 : lhs[j];
            int dIdex2 = rhsLen <= j ? -1 : rhs[j];
            String dim1ValName = dIdex1 < 0 ? null : lhsEncodings.get(dIdex1);
            String string = dim2ValName = dIdex2 < 0 ? null : rhsEncodings.get(dIdex2);
            if (dim1ValName == null || dim2ValName == null) {
                if (dim1ValName == null && dim2ValName == null) continue;
                throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, dim1ValName, dim2ValName);
            }
            if (dim1ValName.equals(dim2ValName)) continue;
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, dim1ValName, dim2ValName);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getDictionaryEncoding();
    }

    @Override
    public int[] getEncodedKeyComponentFromColumn(Closeable column, int currRow) {
        int[] theVals;
        DictionaryEncodedColumn dict = (DictionaryEncodedColumn)column;
        if (dict.hasMultipleValues()) {
            IndexedInts dimVals = dict.getMultiValueRow(currRow);
            theVals = new int[dimVals.size()];
            for (int i = 0; i < theVals.length; ++i) {
                theVals[i] = dimVals.get(i);
            }
        } else {
            theVals = new int[]{dict.getSingleValueRow(currRow)};
        }
        return theVals;
    }

    @Override
    public DimensionIndexer<Integer, int[], String> makeIndexer() {
        return new StringDimensionIndexer(this.multiValueHandling);
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress) {
        return new StringDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium, capabilities, progress);
    }
}

