/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Predicate;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.IdLookup;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.SingleIndexedInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class SingleScanTimeDimSelector
implements DimensionSelector {
    private final ExtractionFn extractionFn;
    private final BaseLongColumnValueSelector selector;
    private final boolean descending;
    private final List<String> timeValues = new ArrayList<String>();
    private String currentValue = null;
    private long currentTimestamp = Long.MIN_VALUE;
    private int index = -1;

    public SingleScanTimeDimSelector(BaseLongColumnValueSelector selector, ExtractionFn extractionFn, boolean descending) {
        if (extractionFn == null) {
            throw new UnsupportedOperationException("time dimension must provide an extraction function");
        }
        this.extractionFn = extractionFn;
        this.selector = selector;
        this.descending = descending;
    }

    @Override
    public IndexedInts getRow() {
        return SingleIndexedInt.of(this.getDimensionValueIndex());
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Objects.equals(SingleScanTimeDimSelector.this.lookupName(SingleScanTimeDimSelector.this.getDimensionValueIndex()), value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", SingleScanTimeDimSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.apply((Object)SingleScanTimeDimSelector.this.lookupName(SingleScanTimeDimSelector.this.getDimensionValueIndex()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", SingleScanTimeDimSelector.this);
                inspector.visit("predicate", predicate);
            }
        };
    }

    private int getDimensionValueIndex() {
        long timestamp = this.selector.getLong();
        if (this.index < 0) {
            this.currentTimestamp = timestamp;
            this.currentValue = this.extractionFn.apply(timestamp);
            ++this.index;
            this.timeValues.add(this.currentValue);
        } else if (timestamp != this.currentTimestamp) {
            if (this.descending ? timestamp > this.currentTimestamp : timestamp < this.currentTimestamp) {
                throw new IllegalStateException("cannot re-use time dimension selector for multiple scans");
            }
            this.currentTimestamp = timestamp;
            String value = this.extractionFn.apply(timestamp);
            if (!Objects.equals(value, this.currentValue)) {
                this.currentValue = value;
                ++this.index;
                this.timeValues.add(this.currentValue);
            }
        }
        return this.index;
    }

    @Override
    public int getValueCardinality() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String lookupName(int id) {
        if (id == this.index) {
            return this.currentValue;
        }
        return this.timeValues.get(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.currentValue;
    }

    @Override
    public Class classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("extractionFn", this.extractionFn);
        inspector.visit("descending", this.descending);
    }
}

