/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.segment.DimensionHandler;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.Metadata;
import io.druid.segment.QueryableIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.data.Indexed;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class SimpleQueryableIndex
implements QueryableIndex {
    private final Interval dataInterval;
    private final Indexed<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final BitmapFactory bitmapFactory;
    private final Map<String, Column> columns;
    private final SmooshedFileMapper fileMapper;
    private final Metadata metadata;
    private final Map<String, DimensionHandler> dimensionHandlers;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> columnNames, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Column> columns, SmooshedFileMapper fileMapper, @Nullable Metadata metadata) {
        Preconditions.checkNotNull((Object)columns.get("__time"));
        this.dataInterval = (Interval)Preconditions.checkNotNull((Object)dataInterval, (Object)"dataInterval");
        this.columnNames = columnNames;
        this.availableDimensions = dimNames;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
        this.dimensionHandlers = Maps.newLinkedHashMap();
        this.initDimensionHandlers();
    }

    @VisibleForTesting
    public SimpleQueryableIndex(Interval interval, Indexed<String> columnNames, Indexed<String> availableDimensions, BitmapFactory bitmapFactory, Map<String, Column> columns, SmooshedFileMapper fileMapper, @Nullable Metadata metadata, Map<String, DimensionHandler> dimensionHandlers) {
        this.dataInterval = interval;
        this.columnNames = columnNames;
        this.availableDimensions = availableDimensions;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
        this.dimensionHandlers = dimensionHandlers;
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.columns.get("__time").getLength();
    }

    @Override
    public Indexed<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return this.bitmapFactory;
    }

    @Override
    @Nullable
    public Column getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    @VisibleForTesting
    public Map<String, Column> getColumns() {
        return this.columns;
    }

    @VisibleForTesting
    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    @Override
    public void close() throws IOException {
        this.fileMapper.close();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.dimensionHandlers;
    }

    private void initDimensionHandlers() {
        for (String dim : this.availableDimensions) {
            ColumnCapabilities capabilities = this.getColumn(dim).getCapabilities();
            DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities(dim, capabilities, null);
            this.dimensionHandlers.put(dim, handler);
        }
    }
}

