/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.io.Closer;
import io.druid.query.BaseQuery;
import io.druid.query.DefaultBitmapResultFactory;
import io.druid.query.QueryMetrics;
import io.druid.query.filter.Filter;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BitmapOffset;
import io.druid.segment.Capabilities;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.Cursor;
import io.druid.segment.FilteredOffset;
import io.druid.segment.Metadata;
import io.druid.segment.NoFilterOffset;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexColumnSelectorFactory;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.Offset;
import io.druid.segment.data.ReadableOffset;
import io.druid.segment.filter.AndFilter;
import io.druid.segment.historical.HistoricalCursor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    private final QueryableIndex index;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return Sets.difference((Set)Sets.newHashSet(this.index.getColumnNames()), (Set)Sets.newHashSet(this.index.getAvailableDimensions()));
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension == null) {
            return 0;
        }
        Column column = this.index.getColumn(dimension);
        if (column == null) {
            return 0;
        }
        if (!column.getCapabilities().isDictionaryEncoded()) {
            return Integer.MAX_VALUE;
        }
        return column.getDictionaryEncoding().getCardinality();
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }

    @Override
    public DateTime getMinTime() {
        try (GenericColumn column = this.index.getColumn("__time").getGenericColumn();){
            DateTime dateTime = DateTimes.utc((long)column.getLongSingleValueRow(0));
            return dateTime;
        }
    }

    @Override
    public DateTime getMaxTime() {
        try (GenericColumn column = this.index.getColumn("__time").getGenericColumn();){
            DateTime dateTime = DateTimes.utc((long)column.getLongSingleValueRow(column.length() - 1));
            return dateTime;
        }
    }

    @Override
    @Nullable
    public Comparable getMinValue(String dimension) {
        Column column = this.index.getColumn(dimension);
        if (column != null && column.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = column.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(0) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String dimension) {
        Column column = this.index.getColumn(dimension);
        if (column != null && column.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = column.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(bitmap.getCardinality() - 1) : null;
        }
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(true).build();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return QueryableIndexStorageAdapter.getColumnCapabilites(this.index, column);
    }

    @Override
    public String getColumnTypeName(String columnName) {
        Column column = this.index.getColumn(columnName);
        try (ComplexColumn complexColumn = column.getComplexColumn();){
            String string = complexColumn != null ? complexColumn.getTypeName() : column.getCapabilities().getType().toString();
            return string;
        }
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        Offset offset;
        List<Filter> preFilters;
        DateTime minTime = this.getMinTime();
        long minDataTimestamp = minTime.getMillis();
        DateTime maxTime = this.getMaxTime();
        long maxDataTimestamp = maxTime.getMillis();
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)gran.bucketEnd(maxTime));
        if (!interval.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        Interval actualInterval = interval.overlap((ReadableInterval)dataInterval);
        ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(this.index.getBitmapFactoryForDimensions(), virtualColumns, this.index);
        int totalRows = this.index.getNumRows();
        ArrayList<Filter> postFilters = new ArrayList<Filter>();
        int preFilteredRows = totalRows;
        if (filter == null) {
            preFilters = Collections.emptyList();
            offset = new NoFilterOffset(0, totalRows, descending);
        } else {
            DefaultBitmapResultFactory bitmapResultFactory;
            preFilters = new ArrayList();
            if (filter instanceof AndFilter) {
                for (Filter subfilter : ((AndFilter)filter).getFilters()) {
                    if (subfilter.supportsBitmapIndex(selector)) {
                        preFilters.add(subfilter);
                        continue;
                    }
                    postFilters.add(subfilter);
                }
            } else if (filter.supportsBitmapIndex(selector)) {
                preFilters.add(filter);
            } else {
                postFilters.add(filter);
            }
            if (preFilters.size() == 0) {
                offset = new NoFilterOffset(0, this.index.getNumRows(), descending);
            } else if (queryMetrics != null) {
                bitmapResultFactory = queryMetrics.makeBitmapResultFactory(selector.getBitmapFactory());
                long bitmapConstructionStartNs = System.nanoTime();
                ImmutableBitmap bitmapIndex = AndFilter.getBitmapIndex(selector, bitmapResultFactory, preFilters);
                preFilteredRows = bitmapIndex.size();
                offset = BitmapOffset.of(bitmapIndex, descending, totalRows);
                queryMetrics.reportBitmapConstructionTime(System.nanoTime() - bitmapConstructionStartNs);
            } else {
                bitmapResultFactory = new DefaultBitmapResultFactory(selector.getBitmapFactory());
                offset = BitmapOffset.of(AndFilter.getBitmapIndex(selector, bitmapResultFactory, preFilters), descending, totalRows);
            }
        }
        Filter postFilter = postFilters.size() == 0 ? null : (postFilters.size() == 1 ? (Filter)postFilters.get(0) : new AndFilter(postFilters));
        if (queryMetrics != null) {
            queryMetrics.preFilters(preFilters);
            queryMetrics.postFilters(postFilters);
            queryMetrics.reportSegmentRows(totalRows);
            queryMetrics.reportPreFilteredRows(preFilteredRows);
        }
        return Sequences.filter(new CursorSequenceBuilder(this, actualInterval, virtualColumns, gran, offset, minDataTimestamp, maxDataTimestamp, descending, postFilter, selector).build(), Objects::nonNull);
    }

    @Nullable
    static ColumnCapabilities getColumnCapabilites(ColumnSelector index, String columnName) {
        Column columnObj = index.getColumn(columnName);
        if (columnObj == null) {
            return null;
        }
        return columnObj.getCapabilities();
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    public static class DescendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        DescendingTimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current >= this.timeLimit;
        }

        public String toString() {
            return this.timeLimit + ">=" + (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new DescendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static class AscendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        AscendingTimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current < this.timeLimit;
        }

        public String toString() {
            return (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "<" + this.timeLimit + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new AscendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static abstract class TimestampCheckingOffset
    extends Offset {
        final Offset baseOffset;
        final GenericColumn timestamps;
        final long timeLimit;
        final boolean allWithinThreshold;

        TimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.timeLimit = timeLimit;
            this.allWithinThreshold = allWithinThreshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public boolean withinBounds() {
            if (!this.baseOffset.withinBounds()) {
                return false;
            }
            if (this.allWithinThreshold) {
                return true;
            }
            return this.timeInRange(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()));
        }

        @Override
        public void reset() {
            this.baseOffset.reset();
        }

        @Override
        public ReadableOffset getBaseReadableOffset() {
            return this.baseOffset.getBaseReadableOffset();
        }

        protected abstract boolean timeInRange(long var1);

        @Override
        public void increment() {
            this.baseOffset.increment();
        }

        @Override
        public Offset clone() {
            throw new IllegalStateException("clone");
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseOffset", this.baseOffset);
            inspector.visit("timestamps", this.timestamps);
            inspector.visit("allWithinThreshold", this.allWithinThreshold);
        }
    }

    private static class QueryableIndexCursor
    implements HistoricalCursor {
        private final Offset cursorOffset;
        private final ColumnSelectorFactory columnSelectorFactory;
        private final DateTime bucketStart;

        QueryableIndexCursor(Offset cursorOffset, ColumnSelectorFactory columnSelectorFactory, DateTime bucketStart) {
            this.cursorOffset = cursorOffset;
            this.columnSelectorFactory = columnSelectorFactory;
            this.bucketStart = bucketStart;
        }

        @Override
        public Offset getOffset() {
            return this.cursorOffset;
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public DateTime getTime() {
            return this.bucketStart;
        }

        @Override
        public void advance() {
            this.cursorOffset.increment();
            BaseQuery.checkInterrupted();
        }

        @Override
        public void advanceUninterruptibly() {
            this.cursorOffset.increment();
        }

        @Override
        public void advanceTo(int offset) {
            for (int count = 0; count < offset && !this.isDone(); ++count) {
                this.advance();
            }
        }

        @Override
        public boolean isDone() {
            return !this.cursorOffset.withinBounds();
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.cursorOffset.reset();
        }
    }

    private static class CursorSequenceBuilder {
        private final QueryableIndex index;
        private final Interval interval;
        private final VirtualColumns virtualColumns;
        private final Granularity gran;
        private final Offset offset;
        private final long minDataTimestamp;
        private final long maxDataTimestamp;
        private final boolean descending;
        private final Filter postFilter;
        private final ColumnSelectorBitmapIndexSelector bitmapIndexSelector;

        public CursorSequenceBuilder(QueryableIndexStorageAdapter storageAdapter, Interval interval, VirtualColumns virtualColumns, Granularity gran, Offset offset, long minDataTimestamp, long maxDataTimestamp, boolean descending, Filter postFilter, ColumnSelectorBitmapIndexSelector bitmapIndexSelector) {
            this.index = storageAdapter.index;
            this.interval = interval;
            this.virtualColumns = virtualColumns;
            this.gran = gran;
            this.offset = offset;
            this.minDataTimestamp = minDataTimestamp;
            this.maxDataTimestamp = maxDataTimestamp;
            this.descending = descending;
            this.postFilter = postFilter;
            this.bitmapIndexSelector = bitmapIndexSelector;
        }

        public Sequence<Cursor> build() {
            final Offset baseOffset = this.offset.clone();
            final HashMap columnCache = new HashMap();
            final GenericColumn timestamps = this.index.getColumn("__time").getGenericColumn();
            final Closer closer = Closer.create();
            closer.register((Closeable)timestamps);
            Iterable iterable = this.gran.getIterable(this.interval);
            if (this.descending) {
                iterable = Lists.reverse((List)ImmutableList.copyOf((Iterable)iterable));
            }
            return Sequences.withBaggage((Sequence)Sequences.map((Sequence)Sequences.simple((Iterable)iterable), (Function)new Function<Interval, Cursor>(){

                public Cursor apply(Interval inputInterval) {
                    long timeStart = Math.max(interval.getStartMillis(), inputInterval.getStartMillis());
                    long timeEnd = Math.min(interval.getEndMillis(), gran.increment(inputInterval.getStart()).getMillis());
                    if (descending) {
                        while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) >= timeEnd) {
                            baseOffset.increment();
                        }
                    } else {
                        while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                            baseOffset.increment();
                        }
                    }
                    TimestampCheckingOffset offset = descending ? new DescendingTimestampCheckingOffset(baseOffset, timestamps, timeStart, minDataTimestamp >= timeStart) : new AscendingTimestampCheckingOffset(baseOffset, timestamps, timeEnd, maxDataTimestamp < timeEnd);
                    Offset baseCursorOffset = ((Offset)offset).clone();
                    QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(index, virtualColumns, descending, closer, baseCursorOffset.getBaseReadableOffset(), columnCache);
                    DateTime myBucket = gran.toDateTime(inputInterval.getStartMillis());
                    if (postFilter == null) {
                        return new QueryableIndexCursor(baseCursorOffset, columnSelectorFactory, myBucket);
                    }
                    FilteredOffset filteredOffset = new FilteredOffset(baseCursorOffset, columnSelectorFactory, descending, postFilter, bitmapIndexSelector);
                    return new QueryableIndexCursor(filteredOffset, columnSelectorFactory, myBucket);
                }
            }), (Closeable)closer);
        }
    }
}

