/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.java.util.common.ISE;
import io.druid.java.util.common.io.Closer;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DimensionSelectorUtils;
import io.druid.segment.NilColumnValueSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexStorageAdapter;
import io.druid.segment.SingleScanTimeDimSelector;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.BaseColumn;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.ReadableOffset;
import java.io.Closeable;
import java.util.Map;
import javax.annotation.Nullable;

class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final QueryableIndex index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final Closer closer;
    protected final ReadableOffset offset;
    private final Map<String, BaseColumn> columnCache;

    QueryableIndexColumnSelectorFactory(QueryableIndex index, VirtualColumns virtualColumns, boolean descending, Closer closer, ReadableOffset offset, Map<String, BaseColumn> columnCache) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.closer = closer;
        this.offset = offset;
        this.columnCache = columnCache;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        Column columnDesc = this.index.getColumn(dimension);
        if (columnDesc == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        ValueType type = columnDesc.getCapabilities().getType();
        if (type.isNumeric()) {
            return type.makeNumericWrappingDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn);
        }
        DictionaryEncodedColumn column = (DictionaryEncodedColumn)this.columnCache.computeIfAbsent(dimension, d -> (DictionaryEncodedColumn)this.closer.register((Closeable)columnDesc.getDictionaryEncoding()));
        if (column == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        return column.makeDimensionSelector(this.offset, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this);
        }
        BaseColumn column = this.columnCache.get(columnName);
        if (column == null) {
            Column holder = this.index.getColumn(columnName);
            if (holder != null) {
                ColumnCapabilities capabilities = holder.getCapabilities();
                if (capabilities.isDictionaryEncoded()) {
                    column = holder.getDictionaryEncoding();
                } else if (capabilities.getType() == ValueType.COMPLEX) {
                    column = holder.getComplexColumn();
                } else if (capabilities.getType().isNumeric()) {
                    column = holder.getGenericColumn();
                } else {
                    throw new ISE("Unknown column type: %s", new Object[]{capabilities.getType()});
                }
                this.closer.register((Closeable)column);
                this.columnCache.put(columnName, column);
            } else {
                return NilColumnValueSelector.instance();
            }
        }
        return column.makeColumnValueSelector(this.offset);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return QueryableIndexStorageAdapter.getColumnCapabilites(this.index, columnName);
    }
}

