/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.IdLookup;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ZeroIndexedInts;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import javax.annotation.Nullable;

public class NullDimensionSelector
implements SingleValueHistoricalDimensionSelector,
IdLookup {
    private static final NullDimensionSelector INSTANCE = new NullDimensionSelector();

    private NullDimensionSelector() {
    }

    public static NullDimensionSelector instance() {
        return INSTANCE;
    }

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getRowValue(int offset) {
        return 0;
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(String value) {
        return BooleanValueMatcher.of(value == null);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return BooleanValueMatcher.of(predicate.apply(null));
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return null;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(String name) {
        return Strings.isNullOrEmpty((String)name) ? 0 : -1;
    }

    @Override
    @Nullable
    public Object getObject() {
        return null;
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

