/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.common.utils.SerializerUtils;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.segment.data.CompressedColumnarFloatsSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MetricHolder {
    private static final byte[] version = new byte[]{0};
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final String name;
    private final String typeName;
    private final MetricType type;
    CompressedColumnarFloatsSupplier floatType = null;
    Indexed complexType = null;

    public static MetricHolder fromByteBuffer(ByteBuffer buf, SmooshedFileMapper mapper) throws IOException {
        return MetricHolder.fromByteBuffer(buf, null, mapper);
    }

    public static MetricHolder fromByteBuffer(ByteBuffer buf, ObjectStrategy strategy, SmooshedFileMapper mapper) throws IOException {
        byte ver = buf.get();
        if (version[0] != ver) {
            throw new ISE("Unknown version[%s] of MetricHolder", new Object[]{ver});
        }
        String metricName = serializerUtils.readString(buf);
        String typeName = serializerUtils.readString(buf);
        MetricHolder holder = new MetricHolder(metricName, typeName);
        switch (holder.type) {
            case FLOAT: {
                holder.floatType = CompressedColumnarFloatsSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder());
                break;
            }
            case COMPLEX: {
                if (strategy != null) {
                    holder.complexType = GenericIndexed.read(buf, strategy, mapper);
                    break;
                }
                ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(holder.getTypeName());
                if (serdeForType == null) {
                    throw new ISE("Unknown type[%s], cannot load.", new Object[]{holder.getTypeName()});
                }
                holder.complexType = GenericIndexed.read(buf, serdeForType.getObjectStrategy());
                break;
            }
            case LONG: 
            case DOUBLE: {
                throw new ISE("Unsupported type[%s]", new Object[]{holder.type});
            }
        }
        return holder;
    }

    private MetricHolder(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
        this.type = MetricType.determineType(typeName);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public MetricType getType() {
        return this.type;
    }

    public static enum MetricType {
        LONG,
        FLOAT,
        DOUBLE,
        COMPLEX;


        static MetricType determineType(String typeName) {
            if ("long".equalsIgnoreCase(typeName)) {
                return LONG;
            }
            if ("float".equalsIgnoreCase(typeName)) {
                return FLOAT;
            }
            if ("double".equalsIgnoreCase(typeName)) {
                return DOUBLE;
            }
            return COMPLEX;
        }
    }
}

