/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.spatial.ImmutableRTree;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.segment.MetricHolder;
import io.druid.segment.data.CompressedColumnarLongsSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.VSizeColumnarMultiInts;
import java.util.Map;
import org.joda.time.Interval;

public class MMappedIndex {
    final GenericIndexed<String> availableDimensions;
    final GenericIndexed<String> availableMetrics;
    final Interval dataInterval;
    final CompressedColumnarLongsSupplier timestamps;
    final Map<String, MetricHolder> metrics;
    final Map<String, GenericIndexed<String>> dimValueLookups;
    final Map<String, VSizeColumnarMultiInts> dimColumns;
    final Map<String, GenericIndexed<ImmutableBitmap>> invertedIndexes;
    final Map<String, ImmutableRTree> spatialIndexes;
    final SmooshedFileMapper fileMapper;

    public MMappedIndex(GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, CompressedColumnarLongsSupplier timestamps, Map<String, MetricHolder> metrics, Map<String, GenericIndexed<String>> dimValueLookups, Map<String, VSizeColumnarMultiInts> dimColumns, Map<String, GenericIndexed<ImmutableBitmap>> invertedIndexes, Map<String, ImmutableRTree> spatialIndexes, SmooshedFileMapper fileMapper) {
        this.availableDimensions = availableDimensions;
        this.availableMetrics = availableMetrics;
        this.dataInterval = dataInterval;
        this.timestamps = timestamps;
        this.metrics = metrics;
        this.dimValueLookups = dimValueLookups;
        this.dimColumns = dimColumns;
        this.invertedIndexes = invertedIndexes;
        this.spatialIndexes = spatialIndexes;
        this.fileMapper = fileMapper;
    }

    public GenericIndexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    public GenericIndexed<String> getAvailableMetrics() {
        return this.availableMetrics;
    }

    public Interval getDataInterval() {
        return this.dataInterval;
    }

    public MetricHolder getMetricHolder(String metric) {
        MetricHolder retVal = this.metrics.get(metric);
        if (retVal == null) {
            return null;
        }
        return retVal;
    }

    public GenericIndexed<String> getDimValueLookup(String dimension) {
        return this.dimValueLookups.get(dimension);
    }

    public VSizeColumnarMultiInts getDimColumn(String dimension) {
        return this.dimColumns.get(dimension);
    }

    public Map<String, GenericIndexed<ImmutableBitmap>> getBitmapIndexes() {
        return this.invertedIndexes;
    }

    public Map<String, ImmutableRTree> getSpatialIndexes() {
        return this.spatialIndexes;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }
}

