/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.LongWrappingDimensionSelector;
import io.druid.segment.data.Indexed;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.TimeAndDimsHolder;
import java.util.List;
import javax.annotation.Nullable;

public class LongDimensionIndexer
implements DimensionIndexer<Long, Long, Long> {
    @Override
    public Long processRowValsToUnsortedEncodedKeyComponent(Object dimValues, boolean reportParseExceptions) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        Long ret = DimensionHandlerUtils.convertObjectToLong(dimValues, reportParseExceptions);
        return ret == null ? DimensionHandlerUtils.ZERO_LONG : ret;
    }

    @Override
    public Long getUnsortedEncodedValueFromSorted(Long sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public Indexed<Long> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Long getMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public Long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new LongWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerLongColumnSelector
        implements LongColumnSelector {
            IndexerLongColumnSelector() {
            }

            @Override
            public long getLong() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return 0L;
                }
                return (Long)dims[dimIndex];
            }

            @Override
            @Nullable
            public Long getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return (Long)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerLongColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Long lhs, @Nullable Long rhs) {
        return DimensionHandlerUtils.nullToZero(lhs).compareTo(DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Long lhs, @Nullable Long rhs) {
        return DimensionHandlerUtils.nullToZero(lhs).equals(DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Long key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(Long key, boolean asList) {
        return key;
    }

    @Override
    public Long convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(Long key) {
        return key;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Long key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

