/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.data.ColumnarLongsSerializer;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class LongColumnSerializer
implements GenericColumnSerializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressionStrategy compression;
    private final CompressionFactory.LongEncodingStrategy encoding;
    private ColumnarLongsSerializer writer;

    public static LongColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding) {
        return new LongColumnSerializer(segmentWriteOutMedium, filenameBase, IndexIO.BYTE_ORDER, compression, encoding);
    }

    private LongColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.encoding = encoding;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getLongSerializer(this.segmentWriteOutMedium, StringUtils.format((String)"%s.long_column", (Object[])new Object[]{this.filenameBase}), this.byteOrder, this.encoding, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        long val = obj == null ? 0L : ((Number)obj).longValue();
        this.writer.add(val);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeTo(channel, smoosher);
    }
}

