/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import io.druid.common.utils.SerializerUtils;
import io.druid.java.util.common.ByteBufferUtils;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.common.guava.nary.BinaryFn;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.common.parsers.CloseableIterator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.DimensionMerger;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.data.Indexed;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.Interval;

@ImplementedBy(value=IndexMergerV9.class)
public interface IndexMerger {
    public static final Logger log = new Logger(IndexMerger.class);
    public static final SerializerUtils serializerUtils = new SerializerUtils();
    public static final int INVALID_ROW = -1;

    public static List<String> getMergedDimensionsFromQueryableIndexes(List<QueryableIndex> indexes) {
        return IndexMerger.getMergedDimensions(IndexMerger.toIndexableAdapters(indexes));
    }

    public static List<IndexableAdapter> toIndexableAdapters(List<QueryableIndex> indexes) {
        return indexes.stream().map(QueryableIndexIndexableAdapter::new).collect(Collectors.toList());
    }

    public static List<String> getMergedDimensions(List<IndexableAdapter> indexes) {
        if (indexes.size() == 0) {
            return ImmutableList.of();
        }
        List<String> commonDimOrder = IndexMerger.getLongestSharedDimOrder(indexes);
        if (commonDimOrder == null) {
            log.warn("Indexes have incompatible dimension orders, using lexicographic order.", new Object[0]);
            return IndexMerger.getLexicographicMergedDimensions(indexes);
        }
        return commonDimOrder;
    }

    public static List<String> getLongestSharedDimOrder(List<IndexableAdapter> indexes) {
        int maxSize = 0;
        Indexed<String> orderingCandidate = null;
        for (IndexableAdapter index : indexes) {
            int iterSize = index.getDimensionNames().size();
            if (iterSize <= maxSize) continue;
            maxSize = iterSize;
            orderingCandidate = index.getDimensionNames();
        }
        if (orderingCandidate == null) {
            return null;
        }
        for (IndexableAdapter index : indexes) {
            Iterator candidateIter = orderingCandidate.iterator();
            for (String matchDim : index.getDimensionNames()) {
                boolean matched = false;
                while (candidateIter.hasNext()) {
                    String nextDim = (String)candidateIter.next();
                    if (!matchDim.equals(nextDim)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return null;
            }
        }
        return ImmutableList.copyOf(orderingCandidate);
    }

    public static List<String> getLexicographicMergedDimensions(List<IndexableAdapter> indexes) {
        return IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
    }

    public static <T extends Comparable<? super T>> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet retVal = Sets.newTreeSet((Comparator)Comparators.naturalNullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList((Iterable)retVal);
    }

    public File persist(IncrementalIndex var1, File var2, IndexSpec var3, @Nullable SegmentWriteOutMediumFactory var4) throws IOException;

    public File persist(IncrementalIndex var1, Interval var2, File var3, IndexSpec var4, @Nullable SegmentWriteOutMediumFactory var5) throws IOException;

    public File persist(IncrementalIndex var1, Interval var2, File var3, IndexSpec var4, ProgressIndicator var5, @Nullable SegmentWriteOutMediumFactory var6) throws IOException;

    public File mergeQueryableIndex(List<QueryableIndex> var1, boolean var2, AggregatorFactory[] var3, File var4, IndexSpec var5, @Nullable SegmentWriteOutMediumFactory var6) throws IOException;

    public File mergeQueryableIndex(List<QueryableIndex> var1, boolean var2, AggregatorFactory[] var3, File var4, IndexSpec var5, ProgressIndicator var6, @Nullable SegmentWriteOutMediumFactory var7) throws IOException;

    @VisibleForTesting
    public File merge(List<IndexableAdapter> var1, boolean var2, AggregatorFactory[] var3, File var4, IndexSpec var5) throws IOException;

    public File convert(File var1, File var2, IndexSpec var3) throws IOException;

    public File convert(File var1, File var2, IndexSpec var3, ProgressIndicator var4, @Nullable SegmentWriteOutMediumFactory var5) throws IOException;

    public File append(List<IndexableAdapter> var1, AggregatorFactory[] var2, File var3, IndexSpec var4, @Nullable SegmentWriteOutMediumFactory var5) throws IOException;

    public static class DictionaryMergeIterator
    implements CloseableIterator<String> {
        protected final IntBuffer[] conversions;
        protected final List<Pair<ByteBuffer, Integer>> directBufferAllocations = Lists.newArrayList();
        protected final PriorityQueue<Pair<Integer, PeekingIterator<String>>> pQueue;
        protected int counter;

        DictionaryMergeIterator(Indexed<String>[] dimValueLookups, boolean useDirect) {
            this.pQueue = new PriorityQueue<Pair<Integer, PeekingIterator<String>>>(dimValueLookups.length, new Comparator<Pair<Integer, PeekingIterator<String>>>(){

                @Override
                public int compare(Pair<Integer, PeekingIterator<String>> lhs, Pair<Integer, PeekingIterator<String>> rhs) {
                    return ((String)((PeekingIterator)lhs.rhs).peek()).compareTo((String)((PeekingIterator)rhs.rhs).peek());
                }
            });
            this.conversions = new IntBuffer[dimValueLookups.length];
            for (int i = 0; i < this.conversions.length; ++i) {
                if (dimValueLookups[i] == null) continue;
                Indexed<String> indexed = dimValueLookups[i];
                if (useDirect) {
                    int allocationSize = indexed.size() * 4;
                    log.info("Allocating dictionary merging direct buffer with size[%,d]", new Object[]{allocationSize});
                    ByteBuffer conversionDirectBuffer = ByteBuffer.allocateDirect(allocationSize);
                    this.conversions[i] = conversionDirectBuffer.asIntBuffer();
                    this.directBufferAllocations.add((Pair<ByteBuffer, Integer>)new Pair((Object)conversionDirectBuffer, (Object)allocationSize));
                } else {
                    this.conversions[i] = IntBuffer.allocate(indexed.size());
                }
                PeekingIterator iter = Iterators.peekingIterator((Iterator)Iterators.transform(indexed.iterator(), (Function)new Function<String, String>(){

                    public String apply(@Nullable String input) {
                        return Strings.nullToEmpty((String)input);
                    }
                }));
                if (!iter.hasNext()) continue;
                this.pQueue.add((Pair<Integer, PeekingIterator<String>>)Pair.of((Object)i, (Object)iter));
            }
        }

        public boolean hasNext() {
            return !this.pQueue.isEmpty();
        }

        public String next() {
            Pair smallest = (Pair)this.pQueue.remove();
            if (smallest == null) {
                throw new NoSuchElementException();
            }
            String value = this.writeTranslate((Pair<Integer, PeekingIterator<String>>)smallest, this.counter);
            while (!this.pQueue.isEmpty() && value.equals(((PeekingIterator)this.pQueue.peek().rhs).peek())) {
                this.writeTranslate((Pair<Integer, PeekingIterator<String>>)((Pair)this.pQueue.remove()), this.counter);
            }
            ++this.counter;
            return value;
        }

        boolean needConversion(int index) {
            IntBuffer readOnly = this.conversions[index].asReadOnlyBuffer();
            readOnly.rewind();
            int i = 0;
            while (readOnly.hasRemaining()) {
                if (i != readOnly.get()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private String writeTranslate(Pair<Integer, PeekingIterator<String>> smallest, int counter) {
            int index = (Integer)smallest.lhs;
            String value = (String)((PeekingIterator)smallest.rhs).next();
            this.conversions[index].put(counter);
            if (((PeekingIterator)smallest.rhs).hasNext()) {
                this.pQueue.add(smallest);
            }
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void close() {
            for (Pair<ByteBuffer, Integer> bufferAllocation : this.directBufferAllocations) {
                log.info("Freeing dictionary merging direct buffer with size[%,d]", new Object[]{bufferAllocation.rhs});
                ByteBufferUtils.free((ByteBuffer)((ByteBuffer)bufferAllocation.lhs));
            }
        }
    }

    public static class RowboatMergeFunction
    implements BinaryFn<Rowboat, Rowboat, Rowboat> {
        private final AggregatorFactory[] metricAggs;

        public RowboatMergeFunction(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        public Rowboat apply(Rowboat lhs, Rowboat rhs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            Object[] metrics = new Object[this.metricAggs.length];
            Object[] lhsMetrics = lhs.getMetrics();
            Object[] rhsMetrics = rhs.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                Object lhsMetric = lhsMetrics[i];
                Object rhsMetric = rhsMetrics[i];
                metrics[i] = lhsMetric == null ? rhsMetric : (rhsMetric == null ? lhsMetric : this.metricAggs[i].combine(lhsMetric, rhsMetric));
            }
            Rowboat retVal = new Rowboat(lhs.getTimestamp(), lhs.getDims(), metrics, lhs.getRowNum(), lhs.getHandlers());
            for (Rowboat rowboat : Arrays.asList(lhs, rhs)) {
                ObjectIterator entryIterator = rowboat.getComprisedRows().int2ObjectEntrySet().fastIterator();
                while (entryIterator.hasNext()) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)entryIterator.next();
                    IntBidirectionalIterator setIterator = ((IntSortedSet)entry.getValue()).iterator();
                    while (setIterator.hasNext()) {
                        int rowNum = setIterator.nextInt();
                        retVal.addRow(entry.getIntKey(), rowNum);
                    }
                }
            }
            return retVal;
        }
    }

    public static class MMappedIndexRowIterable
    implements Iterable<Rowboat> {
        private final Iterable<Rowboat> index;
        private final List<String> convertedDims;
        private final int indexNumber;
        private final List<DimensionMerger> mergers;

        MMappedIndexRowIterable(Iterable<Rowboat> index, List<String> convertedDims, int indexNumber, List<DimensionMerger> mergers) {
            this.index = index;
            this.convertedDims = convertedDims;
            this.indexNumber = indexNumber;
            this.mergers = mergers;
        }

        @Override
        public Iterator<Rowboat> iterator() {
            return Iterators.transform(this.index.iterator(), (Function)new Function<Rowboat, Rowboat>(){

                public Rowboat apply(@Nullable Rowboat input) {
                    Object[] dims = input.getDims();
                    Object[] newDims = new Object[convertedDims.size()];
                    for (int i = 0; i < convertedDims.size(); ++i) {
                        if (i >= dims.length) continue;
                        newDims[i] = ((DimensionMerger)mergers.get(i)).convertSegmentRowValuesToMergedRowValues(dims[i], indexNumber);
                    }
                    Rowboat retVal = new Rowboat(input.getTimestamp(), newDims, input.getMetrics(), input.getRowNum(), input.getHandlers());
                    retVal.addRow(indexNumber, input.getRowNum());
                    return retVal;
                }
            });
        }
    }

    public static class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", new Object[]{dictId, this.lastVal});
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", new Object[]{this.currVal, this.currIndex, dictId});
            }
            return -1;
        }
    }

    public static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

