/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import io.druid.collections.bitmap.ConciseBitmapFactory;
import io.druid.common.utils.SerializerUtils;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.IOE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.io.smoosh.Smoosh;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.segment.DimensionHandler;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.MMappedIndex;
import io.druid.segment.Metadata;
import io.druid.segment.MetricHolder;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.SegmentUtils;
import io.druid.segment.SegmentValidationException;
import io.druid.segment.SimpleQueryableIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ColumnDescriptor;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.ArrayIndexed;
import io.druid.segment.data.BitmapSerde;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ColumnarMultiInts;
import io.druid.segment.data.CompressedColumnarLongsSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ImmutableRTreeObjectStrategy;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.VSizeColumnarMultiInts;
import io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import io.druid.segment.serde.FloatGenericColumnSupplier;
import io.druid.segment.serde.LongGenericColumnSupplier;
import io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class IndexIO {
    public static final byte V8_VERSION = 8;
    public static final byte V9_VERSION = 9;
    public static final int CURRENT_VERSION_ID = 9;
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    private final Map<Integer, IndexLoader> indexLoaders;
    private static final EmittingLogger log = new EmittingLogger(IndexIO.class);
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final ObjectMapper mapper;
    private final SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory;

    @Inject
    public IndexIO(ObjectMapper mapper, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory, ColumnConfig columnConfig) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        this.defaultSegmentWriteOutMediumFactory = (SegmentWriteOutMediumFactory)Preconditions.checkNotNull((Object)defaultSegmentWriteOutMediumFactory, (Object)"null SegmentWriteOutMediumFactory");
        Preconditions.checkNotNull((Object)columnConfig, (Object)"null ColumnConfig");
        ImmutableMap.Builder indexLoadersBuilder = ImmutableMap.builder();
        LegacyIndexLoader legacyIndexLoader = new LegacyIndexLoader(new DefaultIndexIOHandler(), columnConfig);
        for (int i = 0; i <= 8; ++i) {
            indexLoadersBuilder.put((Object)i, (Object)legacyIndexLoader);
        }
        indexLoadersBuilder.put((Object)9, (Object)new V9IndexLoader(columnConfig));
        this.indexLoaders = indexLoadersBuilder.build();
    }

    public void validateTwoSegments(File dir1, File dir2) throws IOException {
        try (QueryableIndex queryableIndex1 = this.loadIndex(dir1);
             QueryableIndex queryableIndex2 = this.loadIndex(dir2);){
            this.validateTwoSegments(new QueryableIndexIndexableAdapter(queryableIndex1), new QueryableIndexIndexableAdapter(queryableIndex2));
        }
    }

    public void validateTwoSegments(IndexableAdapter adapter1, IndexableAdapter adapter2) {
        HashSet metNames2;
        HashSet dimNames2;
        if (adapter1.getNumRows() != adapter2.getNumRows()) {
            throw new SegmentValidationException("Row count mismatch. Expected [%d] found [%d]", adapter1.getNumRows(), adapter2.getNumRows());
        }
        HashSet dimNames1 = Sets.newHashSet(adapter1.getDimensionNames());
        if (!dimNames1.equals(dimNames2 = Sets.newHashSet(adapter2.getDimensionNames()))) {
            throw new SegmentValidationException("Dimension names differ. Expected [%s] found [%s]", dimNames1, dimNames2);
        }
        HashSet metNames1 = Sets.newHashSet(adapter1.getMetricNames());
        if (!metNames1.equals(metNames2 = Sets.newHashSet(adapter2.getMetricNames()))) {
            throw new SegmentValidationException("Metric names differ. Expected [%s] found [%s]", metNames1, metNames2);
        }
        Map<String, DimensionHandler> dimHandlers = adapter1.getDimensionHandlers();
        Iterator<Rowboat> it1 = adapter1.getRows().iterator();
        Iterator<Rowboat> it2 = adapter2.getRows().iterator();
        long row = 0L;
        while (it1.hasNext()) {
            if (!it2.hasNext()) {
                throw new SegmentValidationException("Unexpected end of second adapter", new Object[0]);
            }
            Rowboat rb1 = it1.next();
            Rowboat rb2 = it2.next();
            ++row;
            if (rb1.getRowNum() != rb2.getRowNum()) {
                throw new SegmentValidationException("Row number mismatch: [%d] vs [%d]", rb1.getRowNum(), rb2.getRowNum());
            }
            if (rb1.compareTo(rb2) == 0) continue;
            try {
                IndexIO.validateRowValues(dimHandlers, rb1, adapter1, rb2, adapter2);
            }
            catch (SegmentValidationException ex) {
                throw new SegmentValidationException(ex, "Validation failure on row %d: [%s] vs [%s]", row, rb1, rb2);
            }
        }
        if (it2.hasNext()) {
            throw new SegmentValidationException("Unexpected end of first adapter", new Object[0]);
        }
        if (row != (long)adapter1.getNumRows()) {
            throw new SegmentValidationException("Actual Row count mismatch. Expected [%d] found [%d]", row, adapter1.getNumRows());
        }
    }

    public QueryableIndex loadIndex(File inDir) throws IOException {
        int version = SegmentUtils.getVersionFromDir((File)inDir);
        IndexLoader loader = this.indexLoaders.get(version);
        if (loader != null) {
            return loader.load(inDir, this.mapper);
        }
        throw new ISE("Unknown index version[%s]", new Object[]{version});
    }

    public static int getVersionFromDir(File inDir) throws IOException {
        int version;
        File versionFile = new File(inDir, "version.bin");
        if (versionFile.exists()) {
            return Ints.fromByteArray((byte[])Files.toByteArray((File)versionFile));
        }
        File indexFile = new File(inDir, "index.drd");
        try (FileInputStream in = new FileInputStream(indexFile);){
            version = ((InputStream)in).read();
        }
        return version;
    }

    public static void checkFileSize(File indexFile) throws IOException {
        long fileSize = indexFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOE("File[%s] too large[%d]", new Object[]{indexFile, fileSize});
        }
    }

    public boolean convertSegment(File toConvert, File converted, IndexSpec indexSpec, boolean forceIfCurrent, boolean validate, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        boolean current;
        int version = SegmentUtils.getVersionFromDir((File)toConvert);
        boolean bl = current = version == 9;
        if (!current || forceIfCurrent) {
            if (segmentWriteOutMediumFactory == null) {
                segmentWriteOutMediumFactory = this.defaultSegmentWriteOutMediumFactory;
            }
            new IndexMergerV9(this.mapper, this, segmentWriteOutMediumFactory).convert(toConvert, converted, indexSpec);
            if (validate) {
                this.validateTwoSegments(toConvert, converted);
            }
            return true;
        }
        log.info("Current version[%d], skipping.", new Object[]{version});
        return false;
    }

    public static void validateRowValues(Map<String, DimensionHandler> dimHandlers, Rowboat rb1, IndexableAdapter adapter1, Rowboat rb2, IndexableAdapter adapter2) {
        Object[] dims2;
        if (rb1.getTimestamp() != rb2.getTimestamp()) {
            throw new SegmentValidationException("Timestamp mismatch. Expected %d found %d", rb1.getTimestamp(), rb2.getTimestamp());
        }
        Object[] dims1 = rb1.getDims();
        if (dims1.length != (dims2 = rb2.getDims()).length) {
            throw new SegmentValidationException("Dim lengths not equal %s vs %s", Arrays.deepToString(dims1), Arrays.deepToString(dims2));
        }
        Indexed<String> dim1Names = adapter1.getDimensionNames();
        Indexed<String> dim2Names = adapter2.getDimensionNames();
        for (int i = 0; i < dims1.length; ++i) {
            ValueType dim2Type;
            Object dim1Vals = dims1[i];
            Object dim2Vals = dims2[i];
            String dim1Name = dim1Names.get(i);
            String dim2Name = dim2Names.get(i);
            ColumnCapabilities capabilities1 = adapter1.getCapabilities(dim1Name);
            ColumnCapabilities capabilities2 = adapter2.getCapabilities(dim2Name);
            ValueType dim1Type = capabilities1.getType();
            if (dim1Type != (dim2Type = capabilities2.getType())) {
                throw new SegmentValidationException("Dim [%s] types not equal. Expected %d found %d", new Object[]{dim1Name, dim1Type, dim2Type});
            }
            DimensionHandler dimHandler = dimHandlers.get(dim1Name);
            dimHandler.validateSortedEncodedKeyComponents(dim1Vals, dim2Vals, adapter1.getDimValueLookup(dim1Name), adapter2.getDimValueLookup(dim2Name));
        }
    }

    public static File makeDimFile(File dir, String dimension) {
        return new File(dir, StringUtils.format((String)"dim_%s.drd", (Object[])new Object[]{dimension}));
    }

    public static File makeTimeFile(File dir, ByteOrder order) {
        return new File(dir, StringUtils.format((String)"time_%s.drd", (Object[])new Object[]{order}));
    }

    public static File makeMetricFile(File dir, String metricName, ByteOrder order) {
        return new File(dir, StringUtils.format((String)"met_%s_%s.drd", (Object[])new Object[]{metricName, order}));
    }

    static class V9IndexLoader
    implements IndexLoader {
        private final ColumnConfig columnConfig;

        V9IndexLoader(ColumnConfig columnConfig) {
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper) throws IOException {
            log.debug("Mapping v9 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            int theVersion = Ints.fromByteArray((byte[])Files.toByteArray((File)new File(inDir, "version.bin")));
            if (theVersion != 9) {
                throw new IAE("Expected version[9], got[%d]", new Object[]{theVersion});
            }
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            GenericIndexed<String> cols = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            GenericIndexed<String> dims = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            Interval dataInterval = Intervals.utc((long)indexBuffer.getLong(), (long)indexBuffer.getLong());
            BitmapSerdeFactory segmentBitmapSerdeFactory = indexBuffer.hasRemaining() ? (BitmapSerdeFactory)mapper.readValue(serializerUtils.readString(indexBuffer), BitmapSerdeFactory.class) : new BitmapSerde.LegacyBitmapSerdeFactory();
            Metadata metadata = null;
            ByteBuffer metadataBB = smooshedFiles.mapFile("metadata.drd");
            if (metadataBB != null) {
                try {
                    metadata = (Metadata)mapper.readValue(serializerUtils.readBytes(metadataBB, metadataBB.remaining()), Metadata.class);
                }
                catch (JsonParseException | JsonMappingException ex) {
                    log.warn(ex, "Failed to load metadata for segment [%s]", new Object[]{inDir});
                }
                catch (IOException ex) {
                    throw new IOException("Failed to read metadata", ex);
                }
            }
            HashMap columns = Maps.newHashMap();
            for (String columnName : cols) {
                columns.put(columnName, this.deserializeColumn(mapper, smooshedFiles.mapFile(columnName), smooshedFiles));
            }
            columns.put("__time", this.deserializeColumn(mapper, smooshedFiles.mapFile("__time"), smooshedFiles));
            SimpleQueryableIndex index = new SimpleQueryableIndex(dataInterval, cols, dims, segmentBitmapSerdeFactory.getBitmapFactory(), columns, smooshedFiles, metadata);
            log.debug("Mapped v9 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return index;
        }

        private Column deserializeColumn(ObjectMapper mapper, ByteBuffer byteBuffer, SmooshedFileMapper smooshedFiles) throws IOException {
            ColumnDescriptor serde = (ColumnDescriptor)mapper.readValue(serializerUtils.readString(byteBuffer), ColumnDescriptor.class);
            return serde.read(byteBuffer, this.columnConfig, smooshedFiles);
        }
    }

    static class LegacyIndexLoader
    implements IndexLoader {
        private final IndexIOHandler legacyHandler;
        private final ColumnConfig columnConfig;

        LegacyIndexLoader(IndexIOHandler legacyHandler, ColumnConfig columnConfig) {
            this.legacyHandler = legacyHandler;
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper) throws IOException {
            MMappedIndex index = this.legacyHandler.mapDir(inDir);
            HashMap columns = Maps.newHashMap();
            for (String string : index.getAvailableDimensions()) {
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING).setHasMultipleValues(true).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(index.getDimValueLookup(string), null, (Supplier<ColumnarMultiInts>)Suppliers.ofInstance((Object)index.getDimColumn(string)), this.columnConfig.columnCacheSizeBytes())).setBitmapIndex(new BitmapIndexColumnPartSupplier(new ConciseBitmapFactory(), index.getBitmapIndexes().get(string), index.getDimValueLookup(string)));
                if (index.getSpatialIndexes().get(string) != null) {
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(index.getSpatialIndexes().get(string)));
                }
                columns.put(string, builder.build());
            }
            for (String string : index.getAvailableMetrics()) {
                MetricHolder metricHolder = index.getMetricHolder(string);
                if (metricHolder.getType() == MetricHolder.MetricType.FLOAT) {
                    columns.put(string, new ColumnBuilder().setType(ValueType.FLOAT).setGenericColumn(new FloatGenericColumnSupplier(metricHolder.floatType)).build());
                    continue;
                }
                if (metricHolder.getType() != MetricHolder.MetricType.COMPLEX) continue;
                columns.put(string, new ColumnBuilder().setType(ValueType.COMPLEX).setComplexColumn(new ComplexColumnPartSupplier(metricHolder.getTypeName(), (GenericIndexed)metricHolder.complexType)).build());
            }
            TreeSet colSet = Sets.newTreeSet();
            for (String dimension : index.getAvailableDimensions()) {
                colSet.add(dimension);
            }
            for (String metric : index.getAvailableMetrics()) {
                colSet.add(metric);
            }
            String[] stringArray = colSet.toArray(new String[colSet.size()]);
            columns.put("__time", new ColumnBuilder().setType(ValueType.LONG).setGenericColumn(new LongGenericColumnSupplier(index.timestamps)).build());
            return new SimpleQueryableIndex(index.getDataInterval(), new ArrayIndexed<String>(stringArray, String.class), index.getAvailableDimensions(), new ConciseBitmapFactory(), columns, index.getFileMapper(), null);
        }
    }

    static interface IndexLoader {
        public QueryableIndex load(File var1, ObjectMapper var2) throws IOException;
    }

    public static class DefaultIndexIOHandler
    implements IndexIOHandler {
        private static final Logger log = new Logger(DefaultIndexIOHandler.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MMappedIndex mapDir(File inDir) throws IOException {
            log.debug("Mapping v8 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(inDir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IAE("Unknown version[%d]", new Object[]{theVersion});
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, (boolean)false);
                throw throwable;
            }
            Closeables.close((Closeable)indexIn, (boolean)false);
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            indexBuffer.get();
            GenericIndexed<String> availableDimensions = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            Interval dataInterval = Intervals.of((String)serializerUtils.readString(indexBuffer));
            BitmapSerde.LegacyBitmapSerdeFactory bitmapSerdeFactory = new BitmapSerde.LegacyBitmapSerdeFactory();
            CompressedColumnarLongsSupplier timestamps = CompressedColumnarLongsSupplier.fromByteBuffer(smooshedFiles.mapFile(IndexIO.makeTimeFile(inDir, BYTE_ORDER).getName()), BYTE_ORDER);
            LinkedHashMap metrics = Maps.newLinkedHashMap();
            for (String metric : availableMetrics) {
                String metricFilename;
                Object holder;
                if (!metric.equals(((MetricHolder)(holder = MetricHolder.fromByteBuffer(smooshedFiles.mapFile(metricFilename = IndexIO.makeMetricFile(inDir, metric, BYTE_ORDER).getName()), smooshedFiles))).getName())) {
                    throw new ISE("Metric[%s] loaded up metric[%s] from disk.  File names do matter.", new Object[]{metric, ((MetricHolder)holder).getName()});
                }
                metrics.put(metric, holder);
            }
            HashMap dimValueLookups = Maps.newHashMap();
            HashMap dimColumns = Maps.newHashMap();
            HashMap bitmaps = Maps.newHashMap();
            for (String dimension : IndexedIterable.create(availableDimensions)) {
                ByteBuffer dimBuffer = smooshedFiles.mapFile(IndexIO.makeDimFile(inDir, dimension).getName());
                String fileDimensionName = serializerUtils.readString(dimBuffer);
                Preconditions.checkState((boolean)dimension.equals(fileDimensionName), (String)"Dimension file[%s] has dimension[%s] in it!?", (Object[])new Object[]{IndexIO.makeDimFile(inDir, dimension), fileDimensionName});
                dimValueLookups.put(dimension, GenericIndexed.read(dimBuffer, GenericIndexed.STRING_STRATEGY));
                dimColumns.put(dimension, VSizeColumnarMultiInts.readFromByteBuffer(dimBuffer));
            }
            ByteBuffer invertedBuffer = smooshedFiles.mapFile("inverted.drd");
            for (int i = 0; i < availableDimensions.size(); ++i) {
                bitmaps.put(serializerUtils.readString(invertedBuffer), GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
            }
            HashMap spatialIndexed = Maps.newHashMap();
            ByteBuffer spatialBuffer = smooshedFiles.mapFile("spatial.drd");
            while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                spatialIndexed.put(serializerUtils.readString(spatialBuffer), new ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory()).fromByteBufferWithSize(spatialBuffer));
            }
            MMappedIndex retVal = new MMappedIndex(availableDimensions, availableMetrics, dataInterval, timestamps, metrics, dimValueLookups, dimColumns, bitmaps, spatialIndexed, smooshedFiles);
            log.debug("Mapped v8 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return retVal;
        }
    }

    static interface IndexIOHandler {
        public MMappedIndex mapDir(File var1) throws IOException;
    }
}

