/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.query.extraction.ExtractionFn;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseFloatColumnValueSelector;
import io.druid.segment.virtual.BaseSingleValueDimensionSelector;
import javax.annotation.Nullable;

public class FloatWrappingDimensionSelector
extends BaseSingleValueDimensionSelector {
    private final BaseFloatColumnValueSelector selector;
    private final ExtractionFn extractionFn;

    public FloatWrappingDimensionSelector(BaseFloatColumnValueSelector selector, ExtractionFn extractionFn) {
        this.selector = selector;
        this.extractionFn = extractionFn;
    }

    @Override
    protected String getValue() {
        if (this.extractionFn == null) {
            return String.valueOf(this.selector.getFloat());
        }
        return this.extractionFn.apply(Float.valueOf(this.selector.getFloat()));
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.getValue();
    }

    @Override
    public Class classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("extractionFn", this.extractionFn);
    }
}

