/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.DimensionMergerV9;
import io.druid.segment.FloatColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.column.ColumnDescriptor;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.serde.FloatGenericColumnPartSerde;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.List;

public class FloatDimensionMergerV9
implements DimensionMergerV9<Float> {
    protected String dimensionName;
    protected final IndexSpec indexSpec;
    private FloatColumnSerializer serializer;

    public FloatDimensionMergerV9(String dimensionName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        try {
            this.setupEncodedValueWriter(segmentWriteOutMedium);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void setupEncodedValueWriter(SegmentWriteOutMedium segmentWriteOutMedium) throws IOException {
        CompressionStrategy metCompression = this.indexSpec.getMetricCompression();
        this.serializer = FloatColumnSerializer.create(segmentWriteOutMedium, this.dimensionName, metCompression);
        this.serializer.open();
    }

    @Override
    public void writeMergedValueMetadata(List<IndexableAdapter> adapters) throws IOException {
    }

    @Override
    public Float convertSegmentRowValuesToMergedRowValues(Float segmentRow, int segmentIndexNumber) {
        return segmentRow;
    }

    @Override
    public void processMergedRow(Float rowValues) throws IOException {
        this.serializer.serialize(rowValues);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions) throws IOException {
    }

    @Override
    public boolean canSkip() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() throws IOException {
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.FLOAT);
        builder.addSerde(FloatGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(this.serializer).build());
        return builder.build();
    }
}

