/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.DimensionHandler;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionMergerV9;
import io.druid.segment.FloatDimensionIndexer;
import io.druid.segment.FloatDimensionMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.SegmentValidationException;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.data.Indexed;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.Closeable;
import java.io.IOException;

public class FloatDimensionHandler
implements DimensionHandler<Float, Float, Float> {
    private final String dimensionName;

    public FloatDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionIndexer<Float, Float, Float> makeIndexer() {
        return new FloatDimensionIndexer();
    }

    @Override
    public DimensionMergerV9<Float> makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress) throws IOException {
        return new FloatDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(Float dimVals) {
        return 1;
    }

    @Override
    public int compareSortedEncodedKeyComponents(Float lhs, Float rhs) {
        return lhs.compareTo(rhs);
    }

    @Override
    public void validateSortedEncodedKeyComponents(Float lhs, Float rhs, Indexed<Float> lhsEncodings, Indexed<Float> rhsEncodings) throws SegmentValidationException {
        if (!lhs.equals(rhs)) {
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, lhs, rhs);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getGenericColumn();
    }

    @Override
    public Float getEncodedKeyComponentFromColumn(Closeable column, int currRow) {
        return Float.valueOf(((GenericColumn)column).getFloatSingleValueRow(currRow));
    }
}

