/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DoubleColumnSelector;
import io.druid.segment.DoubleWrappingDimensionSelector;
import io.druid.segment.data.Indexed;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.TimeAndDimsHolder;
import java.util.List;
import javax.annotation.Nullable;

public class DoubleDimensionIndexer
implements DimensionIndexer<Double, Double, Double> {
    @Override
    public Double processRowValsToUnsortedEncodedKeyComponent(Object dimValues, boolean reportParseExceptions) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        Double ret = DimensionHandlerUtils.convertObjectToDouble(dimValues, reportParseExceptions);
        return ret == null ? DimensionHandlerUtils.ZERO_DOUBLE : ret;
    }

    @Override
    public Double getUnsortedEncodedValueFromSorted(Double sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public Indexed<Double> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Double getMinValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new DoubleWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerDoubleColumnSelector
        implements DoubleColumnSelector {
            IndexerDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0;
                }
                return (Double)dims[dimIndex];
            }

            @Override
            @Nullable
            public Double getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return (Double)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDoubleColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Double lhs, @Nullable Double rhs) {
        return Double.compare(DimensionHandlerUtils.nullToZero(lhs), DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Double lhs, @Nullable Double rhs) {
        return DimensionHandlerUtils.nullToZero(lhs).equals(DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Double key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(Double key, boolean asList) {
        return key;
    }

    @Override
    public Double convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(Double key) {
        return key;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Double key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

