/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.DimensionHandler;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionMergerV9;
import io.druid.segment.DoubleDimensionIndexer;
import io.druid.segment.DoubleDimensionMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.SegmentValidationException;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.data.Indexed;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.Closeable;
import java.io.IOException;

public class DoubleDimensionHandler
implements DimensionHandler<Double, Double, Double> {
    private final String dimensionName;

    public DoubleDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionIndexer<Double, Double, Double> makeIndexer() {
        return new DoubleDimensionIndexer();
    }

    @Override
    public DimensionMergerV9<Double> makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress) throws IOException {
        return new DoubleDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(Double dimVals) {
        return 1;
    }

    @Override
    public int compareSortedEncodedKeyComponents(Double lhs, Double rhs) {
        return lhs.compareTo(rhs);
    }

    @Override
    public void validateSortedEncodedKeyComponents(Double lhs, Double rhs, Indexed<Double> lhsEncodings, Indexed<Double> rhsEncodings) throws SegmentValidationException {
        if (!lhs.equals(rhs)) {
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, lhs, rhs);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getGenericColumn();
    }

    @Override
    public Double getEncodedKeyComponentFromColumn(Closeable column, int currRow) {
        return ((GenericColumn)column).getDoubleSingleValueRow(currRow);
    }
}

