/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.data.ColumnarDoublesSerializer;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class DoubleColumnSerializer
implements GenericColumnSerializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressionStrategy compression;
    private ColumnarDoublesSerializer writer;

    public static DoubleColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compression) {
        return new DoubleColumnSerializer(segmentWriteOutMedium, filenameBase, IndexIO.BYTE_ORDER, compression);
    }

    private DoubleColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getDoubleSerializer(this.segmentWriteOutMedium, StringUtils.format((String)"%s.double_column", (Object[])new Object[]{this.filenameBase}), this.byteOrder, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        double val = obj == null ? 0.0 : ((Number)obj).doubleValue();
        this.writer.add(val);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeTo(channel, smoosher);
    }
}

