/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import io.druid.java.util.common.IAE;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ConstantDimensionSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.IdLookup;
import io.druid.segment.NullDimensionSelector;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.BooleanValueMatcher;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DimensionSelectorUtils {
    private DimensionSelectorUtils() {
    }

    public static ValueMatcher makeValueMatcherGeneric(DimensionSelector selector, String value) {
        IdLookup idLookup = selector.idLookup();
        if (idLookup != null) {
            return DimensionSelectorUtils.makeDictionaryEncodedValueMatcherGeneric(selector, idLookup.lookupId(value), value == null);
        }
        if (selector.getValueCardinality() >= 0 && selector.nameLookupPossibleInAdvance()) {
            return DimensionSelectorUtils.makeDictionaryEncodedValueMatcherGeneric(selector, (Predicate<String>)Predicates.equalTo((Object)value));
        }
        return DimensionSelectorUtils.makeNonDictionaryEncodedValueMatcherGeneric(selector, value);
    }

    private static ValueMatcher makeDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final int valueId, final boolean matchNull) {
        if (valueId >= 0) {
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    IndexedInts row = selector.getRow();
                    int size = row.size();
                    if (size == 0) {
                        return matchNull;
                    }
                    for (int i = 0; i < size; ++i) {
                        if (row.get(i) != valueId) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        if (matchNull) {
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    IndexedInts row = selector.getRow();
                    int size = row.size();
                    return size == 0;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        return BooleanValueMatcher.of(false);
    }

    private static ValueMatcher makeNonDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return value == null;
                }
                for (int i = 0; i < size; ++i) {
                    if (!Objects.equals(selector.lookupName(row.get(i)), value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeValueMatcherGeneric(DimensionSelector selector, Predicate<String> predicate) {
        int cardinality = selector.getValueCardinality();
        if (cardinality >= 0 && selector.nameLookupPossibleInAdvance()) {
            return DimensionSelectorUtils.makeDictionaryEncodedValueMatcherGeneric(selector, predicate);
        }
        return DimensionSelectorUtils.makeNonDictionaryEncodedValueMatcherGeneric(selector, predicate);
    }

    private static ValueMatcher makeDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, Predicate<String> predicate) {
        final BitSet predicateMatchingValueIds = DimensionSelectorUtils.makePredicateMatchingSet(selector, predicate);
        final boolean matchNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return matchNull;
                }
                for (int i = 0; i < size; ++i) {
                    if (!predicateMatchingValueIds.get(row.get(i))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    private static ValueMatcher makeNonDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final Predicate<String> predicate) {
        final boolean matchNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return matchNull;
                }
                for (int i = 0; i < size; ++i) {
                    if (!predicate.apply((Object)selector.lookupName(row.get(i)))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static BitSet makePredicateMatchingSet(DimensionSelector selector, Predicate<String> predicate) {
        if (!selector.nameLookupPossibleInAdvance()) {
            throw new IAE("selector.nameLookupPossibleInAdvance() should return true", new Object[0]);
        }
        int cardinality = selector.getValueCardinality();
        BitSet valueIds = new BitSet(cardinality);
        for (int i = 0; i < cardinality; ++i) {
            if (!predicate.apply((Object)selector.lookupName(i))) continue;
            valueIds.set(i);
        }
        return valueIds;
    }

    public static DimensionSelector constantSelector(@Nullable String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return NullDimensionSelector.instance();
        }
        return new ConstantDimensionSelector(value);
    }

    public static DimensionSelector constantSelector(@Nullable String value, @Nullable ExtractionFn extractionFn) {
        if (extractionFn == null) {
            return DimensionSelectorUtils.constantSelector(value);
        }
        return DimensionSelectorUtils.constantSelector(extractionFn.apply(value));
    }
}

