/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import io.druid.common.guava.GuavaUtils;
import io.druid.data.input.impl.DimensionSchema;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.dimension.ColumnSelectorStrategy;
import io.druid.query.dimension.ColumnSelectorStrategyFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionHandler;
import io.druid.segment.DoubleDimensionHandler;
import io.druid.segment.FloatDimensionHandler;
import io.druid.segment.LongDimensionHandler;
import io.druid.segment.StringDimensionHandler;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class DimensionHandlerUtils {
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Long ZERO_LONG = 0L;
    public static final ColumnCapabilities DEFAULT_STRING_CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setHasBitmapIndexes(true);

    private DimensionHandlerUtils() {
    }

    public static DimensionHandler getHandlerFromCapabilities(String dimensionName, ColumnCapabilities capabilities, DimensionSchema.MultiValueHandling multiValueHandling) {
        if (capabilities == null) {
            return new StringDimensionHandler(dimensionName, multiValueHandling);
        }
        DimensionSchema.MultiValueHandling multiValueHandling2 = multiValueHandling = multiValueHandling == null ? DimensionSchema.MultiValueHandling.ofDefault() : multiValueHandling;
        if (capabilities.getType() == ValueType.STRING) {
            if (!capabilities.isDictionaryEncoded() || !capabilities.hasBitmapIndexes()) {
                throw new IAE("String column must have dictionary encoding and bitmap index.", new Object[0]);
            }
            return new StringDimensionHandler(dimensionName, multiValueHandling);
        }
        if (capabilities.getType() == ValueType.LONG) {
            return new LongDimensionHandler(dimensionName);
        }
        if (capabilities.getType() == ValueType.FLOAT) {
            return new FloatDimensionHandler(dimensionName);
        }
        if (capabilities.getType() == ValueType.DOUBLE) {
            return new DoubleDimensionHandler(dimensionName);
        }
        return new StringDimensionHandler(dimensionName, multiValueHandling);
    }

    public static List<ValueType> getValueTypesFromDimensionSpecs(List<DimensionSpec> dimSpecs) {
        ArrayList<ValueType> types = new ArrayList<ValueType>(dimSpecs.size());
        for (DimensionSpec dimSpec : dimSpecs) {
            types.add(dimSpec.getOutputType());
        }
        return types;
    }

    public static <ColumnSelectorStrategyClass extends ColumnSelectorStrategy> ColumnSelectorPlus<ColumnSelectorStrategyClass> createColumnSelectorPlus(ColumnSelectorStrategyFactory<ColumnSelectorStrategyClass> strategyFactory, DimensionSpec dimensionSpec, ColumnSelectorFactory cursor) {
        return DimensionHandlerUtils.createColumnSelectorPluses(strategyFactory, (List<DimensionSpec>)ImmutableList.of((Object)dimensionSpec), cursor)[0];
    }

    public static <ColumnSelectorStrategyClass extends ColumnSelectorStrategy> ColumnSelectorPlus<ColumnSelectorStrategyClass>[] createColumnSelectorPluses(ColumnSelectorStrategyFactory<ColumnSelectorStrategyClass> strategyFactory, List<DimensionSpec> dimensionSpecs, ColumnSelectorFactory columnSelectorFactory) {
        int dimCount = dimensionSpecs.size();
        ColumnSelectorPlus[] dims = new ColumnSelectorPlus[dimCount];
        for (int i = 0; i < dimCount; ++i) {
            ColumnSelectorPlus<ColumnSelectorStrategyClass> selectorPlus;
            DimensionSpec dimSpec = dimensionSpecs.get(i);
            String dimName = dimSpec.getDimension();
            ColumnValueSelector selector = DimensionHandlerUtils.getColumnValueSelectorFromDimensionSpec(dimSpec, columnSelectorFactory);
            ColumnSelectorStrategyClass strategy = DimensionHandlerUtils.makeStrategy(strategyFactory, dimSpec, columnSelectorFactory.getColumnCapabilities(dimSpec.getDimension()), selector);
            dims[i] = selectorPlus = new ColumnSelectorPlus<ColumnSelectorStrategyClass>(dimName, dimSpec.getOutputName(), strategy, selector);
        }
        return dims;
    }

    public static ColumnValueSelector getColumnValueSelectorFromDimensionSpec(DimensionSpec dimSpec, ColumnSelectorFactory columnSelectorFactory) {
        String dimName = dimSpec.getDimension();
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(dimName);
        capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimSpec, capabilities);
        switch (capabilities.getType()) {
            case STRING: {
                return columnSelectorFactory.makeDimensionSelector(dimSpec);
            }
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return columnSelectorFactory.makeColumnValueSelector(dimSpec.getDimension());
            }
        }
        return null;
    }

    private static ColumnCapabilities getEffectiveCapabilities(DimensionSpec dimSpec, ColumnCapabilities capabilities) {
        if (capabilities == null) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (capabilities.getType() == ValueType.COMPLEX) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (dimSpec.getExtractionFn() != null) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (ValueType.isNumeric(capabilities.getType()) && dimSpec.mustDecorate()) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        return capabilities;
    }

    private static <ColumnSelectorStrategyClass extends ColumnSelectorStrategy> ColumnSelectorStrategyClass makeStrategy(ColumnSelectorStrategyFactory<ColumnSelectorStrategyClass> strategyFactory, DimensionSpec dimSpec, ColumnCapabilities capabilities, ColumnValueSelector selector) {
        capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimSpec, capabilities);
        return strategyFactory.makeColumnSelectorStrategy(capabilities, selector);
    }

    @Nullable
    public static Long convertObjectToLong(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToLong(valObj, false);
    }

    @Nullable
    public static Long convertObjectToLong(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return ZERO_LONG;
        }
        if (valObj instanceof Long) {
            return (Long)valObj;
        }
        if (valObj instanceof Number) {
            return ((Number)valObj).longValue();
        }
        if (valObj instanceof String) {
            Long ret = DimensionHandlerUtils.getExactLongFromDecimalString((String)valObj);
            if (reportParseExceptions && ret == null) {
                throw new ParseException("could not convert value [%s] to long", new Object[]{valObj});
            }
            return ret;
        }
        throw new ParseException("Unknown type[%s]", new Object[]{valObj.getClass()});
    }

    @Nullable
    public static Float convertObjectToFloat(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToFloat(valObj, false);
    }

    @Nullable
    public static Float convertObjectToFloat(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return ZERO_FLOAT;
        }
        if (valObj instanceof Float) {
            return (Float)valObj;
        }
        if (valObj instanceof Number) {
            return Float.valueOf(((Number)valObj).floatValue());
        }
        if (valObj instanceof String) {
            Float ret = Floats.tryParse((String)((String)valObj));
            if (reportParseExceptions && ret == null) {
                throw new ParseException("could not convert value [%s] to float", new Object[]{valObj});
            }
            return ret;
        }
        throw new ParseException("Unknown type[%s]", new Object[]{valObj.getClass()});
    }

    @Nullable
    public static Double convertObjectToDouble(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToDouble(valObj, false);
    }

    @Nullable
    public static Double convertObjectToDouble(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return ZERO_DOUBLE;
        }
        if (valObj instanceof Double) {
            return (Double)valObj;
        }
        if (valObj instanceof Number) {
            return ((Number)valObj).doubleValue();
        }
        if (valObj instanceof String) {
            Double ret = Doubles.tryParse((String)((String)valObj));
            if (reportParseExceptions && ret == null) {
                throw new ParseException("could not convert value [%s] to double", new Object[]{valObj});
            }
            return ret;
        }
        throw new ParseException("Unknown type[%s]", new Object[]{valObj.getClass()});
    }

    @Nullable
    public static Long getExactLongFromDecimalString(String decimalStr) {
        BigDecimal convertedBD;
        Long val = GuavaUtils.tryParseLong((String)decimalStr);
        if (val != null) {
            return val;
        }
        try {
            convertedBD = new BigDecimal(decimalStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            return convertedBD.longValueExact();
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }

    public static Double nullToZero(@Nullable Double number) {
        return number == null ? ZERO_DOUBLE : number;
    }

    public static Long nullToZero(@Nullable Long number) {
        return number == null ? ZERO_LONG : number;
    }

    public static Float nullToZero(@Nullable Float number) {
        return number == null ? ZERO_FLOAT : number;
    }
}

