/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.IdLookup;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ZeroIndexedInts;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import java.util.Objects;
import javax.annotation.Nullable;

public class ConstantDimensionSelector
implements SingleValueHistoricalDimensionSelector,
IdLookup {
    private final String value;

    public ConstantDimensionSelector(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Use NullDimensionSelector or DimensionSelectorUtils.constantSelector");
        }
        this.value = value;
    }

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getRowValue(int offset) {
        return 0;
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(String matchValue) {
        return BooleanValueMatcher.of(Objects.equals(this.value, matchValue));
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return BooleanValueMatcher.of(predicate.apply((Object)this.value));
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return this.value;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(String name) {
        return this.value.equals(name) ? 0 : -1;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.value;
    }

    @Override
    public Class classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("value", this.value);
    }
}

